/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.test;

import de.pontonconsulting.xmlpipe.Util;
import de.pontonconsulting.xmlpipe.adapter.MessageResult;
import java.io.File;
import java.io.Serializable;

public class MessageBean
implements Serializable {
    private static final long serialVersionUID = -8391605503668232810L;
    protected static final String DIRECTION_OUT = "OUT";
    protected static final String DIRECTION_IN = "IN";
    private String _time;
    private String _messageID;
    private String _conversationID;
    private String _protocol;
    private String _messageType;
    private String _schemaVersion;
    private String _schemaSet;
    private String _sender;
    private String _senderInternalID;
    private String _receiver;
    private String _receiverInternalID;
    private boolean _test;
    private String _status;
    private String _direction;
    private boolean _isError = true;
    private File _file;
    private String[] _helpDescription;
    private long _startLocalTime = -1L;
    private long _endLocalTime = -1L;

    public MessageBean() {
    }

    public MessageBean(String time, String messageID, String conversationID, String protocol, String sender, String senderInternalID, String receiver, String receiverInternalID, String messageType, String schemaVersion, String schemaSet, boolean test, String direction, MessageResult result, File file, String[] helpDescription) {
        this();
        this._time = time;
        this._messageID = messageID;
        this._conversationID = conversationID;
        this._protocol = protocol;
        this._messageType = messageType;
        this._schemaVersion = schemaVersion;
        this._schemaSet = schemaSet;
        this._sender = sender;
        this._senderInternalID = senderInternalID;
        this._receiver = receiver;
        this._receiverInternalID = receiverInternalID;
        this._test = test;
        this._direction = direction;
        this._helpDescription = helpDescription;
        this._status = result.getDescription();
        if (direction.equals(DIRECTION_IN) && this.successfullyReceived(result) || direction.equals(DIRECTION_OUT) && this.successfullySent(result)) {
            this._isError = false;
        }
        this._file = file;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String getReceiver() {
        return this._receiver;
    }

    public String getReceiverInternalID() {
        return this._receiverInternalID;
    }

    public String getSender() {
        return this._sender;
    }

    public String getSenderInternalID() {
        return this._senderInternalID;
    }

    public String getStatus() {
        return this._status;
    }

    public boolean getTest() {
        return this._test;
    }

    public String getTime() {
        return this._time;
    }

    public String getMessageID() {
        return this._messageID;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public void setReceiver(String receiver) {
        this._receiver = receiver;
    }

    public void setReceiverInternalID(String receiverInternalID) {
        this._receiverInternalID = receiverInternalID;
    }

    public void setSender(String sender) {
        this._sender = sender;
    }

    public void setsenderInternalID(String senderInternalID) {
        this._senderInternalID = senderInternalID;
    }

    public void setStatus(String status) {
        this._status = status;
    }

    public void setTest(boolean test) {
        this._test = test;
    }

    public void setTime(String time) {
        this._time = time;
    }

    public void setMessageID(String messageID) {
        this._messageID = messageID;
    }

    public boolean isError() {
        return this._isError;
    }

    public boolean isWaiting() {
        return this.getEndLocalTime() < 0L;
    }

    public boolean isSuccessful() {
        return !this.isError() && !this.isWaiting();
    }

    public void setError(boolean isError) {
        this._isError = isError;
    }

    public String getDirection() {
        return this._direction;
    }

    public void setDirection(String direction) {
        this._direction = direction;
    }

    public File getFile() {
        return this._file;
    }

    public void setFile(File file) {
        this._file = file;
    }

    private boolean successfullyReceived(MessageResult result) {
        return result.equals((Object)MessageResult.MSG_SUCCESSFULLY_RECEIVED);
    }

    private boolean successfullySent(MessageResult result) {
        return result.equals((Object)MessageResult.MSG_SUCCESSFULLY_SEND);
    }

    public String getMessageType() {
        return this._messageType;
    }

    public String getSchemaSet() {
        return this._schemaSet;
    }

    public String getSchemaVersion() {
        return this._schemaVersion;
    }

    public void setMessageType(String string) {
        this._messageType = string;
    }

    public void setSchemaSet(String string) {
        this._schemaSet = string;
    }

    public void setSchemaVersion(String string) {
        this._schemaVersion = string;
    }

    public String getConversationID() {
        return this._conversationID;
    }

    public void setConversationID(String string) {
        this._conversationID = string;
    }

    public long getEndLocalTime() {
        return this._endLocalTime;
    }

    public void setEndLocalTime(long endLocalTime) {
        this._endLocalTime = endLocalTime;
    }

    public long getStartLocalTime() {
        return this._startLocalTime;
    }

    public void setStartLocalTime(long startLocalTime) {
        this._startLocalTime = startLocalTime;
    }

    public long getPingLoopTime() {
        long loopTime = this.getEndLocalTime() - this.getStartLocalTime();
        if (loopTime < 0L) {
            return -1L;
        }
        return loopTime;
    }

    public String getPingLoopTimeFormated() {
        Object result = "";
        long loopTime = this.getPingLoopTime();
        if (loopTime < 0L) {
            result = "";
        } else {
            result = Util.formatDouble((double)loopTime / 1000.0, "0.#");
            result = (String)result + "s";
        }
        return result;
    }

    public String[] getHelpDescription() {
        return this._helpDescription;
    }
}

