/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.nulladapter;

import de.pontonconsulting.xmlpipe.adapter.GenericAdapter;
import de.pontonconsulting.xmlpipe.adapter.IInternalAdapter;
import de.pontonconsulting.xmlpipe.adapter.ISpecificAdapter;
import de.pontonconsulting.xmlpipe.adapter.MessageResult;
import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import java.io.File;
import java.net.URL;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NullAdapter
implements ISpecificAdapter,
IInternalAdapter {
    private static final MessageResult RESULT_SUCCESSFULLY_RECEIVED = new MessageResult(MessageResult.MSG_SUCCESSFULLY_RECEIVED);
    private boolean _initialized = false;
    private GenericAdapter _ga;
    private Log _log;
    private int _numberOfReceivedMessages;
    private File _workFolder;
    private NullAdapter _nullAdapter;

    public void init(URL configResource) throws Exception {
        this.setNullAdapter(this);
        if (!this._initialized) {
            this.setLog(LogFactory.getFactory().getInstance("NullAdapter.NullAdapter"));
            this.getLog().info((Object)"Initializing.");
            String temp = System.getProperty("java.io.tmpdir");
            this._workFolder = new File(new File(temp), "NullAdapterWork");
            if (!this._workFolder.exists()) {
                this._workFolder.mkdirs();
            }
            this.getLog().info((Object)("Using WorkFolder: " + this.getWorkFolder().getAbsolutePath()));
            Thread startup = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        NullAdapter.this.setGenericAdapter(new GenericAdapter("NullAdapter"));
                        NullAdapter.this.getGenericAdapter().setServerPort(-1);
                        NullAdapter.this.getGenericAdapter().setEndAdapter((ISpecificAdapter)NullAdapter.this.getNullAdapter());
                        NullAdapter.this.getGenericAdapter().addMessengerConnection("localhost", 8080, "/pontonxp/AdapterService");
                    }
                    catch (Exception e) {
                        NullAdapter.this.getLog().fatal((Object)"Connection to messenger cound not be established.", (Throwable)e);
                    }
                }
            });
            startup.start();
            this.getLog().info((Object)"Finished init.");
            this._initialized = true;
        }
    }

    public String getID() {
        return "NullAdapter";
    }

    public String getStatus() {
        String status = "<font class=\"font\" id=\"normal\" >&nbsp;&nbsp;Status for " + this.getID() + ":</font><br>";
        status = status + "<font class=\"font\" id=\"content\" >&nbsp;&nbsp;Received " + this._numberOfReceivedMessages + " Messages.</font>\n";
        return status;
    }

    public boolean supportsAcknowledgements() {
        return false;
    }

    public boolean supportsAttachments() {
        return false;
    }

    public int getNumberOfParallelThreads() {
        return 10;
    }

    public MessageResult receiveMessage(BackEndMessage message) {
        ++this._numberOfReceivedMessages;
        return RESULT_SUCCESSFULLY_RECEIVED;
    }

    public MessageResult receiveTestMessage(BackEndMessage message) {
        ++this._numberOfReceivedMessages;
        return RESULT_SUCCESSFULLY_RECEIVED;
    }

    public MessageResult receiveAcknowledgement(BackEndMessage message) {
        return RESULT_SUCCESSFULLY_RECEIVED;
    }

    public File getWorkFolder() {
        return this._workFolder;
    }

    public boolean doSelfCheck() {
        return true;
    }

    public String shutdown() {
        if (Objects.isNull(this.getGenericAdapter())) {
            return "---";
        }
        return this.getGenericAdapter().shutdown().getDescription();
    }

    public void stop() throws Exception {
        String result = this.shutdown();
        this.getLog().info((Object)("stopping NullAdapter: " + result));
    }

    public NullAdapter getNullAdapter() {
        return this._nullAdapter;
    }

    public void setNullAdapter(NullAdapter nullAdapter) {
        this._nullAdapter = nullAdapter;
    }

    public GenericAdapter getGenericAdapter() {
        return this._ga;
    }

    public void setGenericAdapter(GenericAdapter ga) {
        this._ga = ga;
    }

    public Log getLog() {
        return this._log;
    }

    public void setLog(Log log) {
        this._log = log;
    }
}

