/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.hotfolder.support;

import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderAdapter;
import java.io.File;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.util.FileUtil;

public class LockStrategy
implements GenericFileExclusiveReadLockStrategy<File> {
    public void prepareOnStartup(GenericFileOperations<File> operations, GenericFileEndpoint<File> endpoint) {
        String dir = endpoint.getConfiguration().getDirectory();
        File file = new File(dir);
        LockStrategy.deleteLockFiles(file, endpoint.isRecursive());
    }

    public boolean acquireExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        String lockFileName = LockStrategy.getLockFileName(file);
        File lock = new File(lockFileName);
        boolean acquired = lock.createNewFile();
        if (acquired) {
            HotFolderAdapter.LOG.trace("Lock acquired for {}", (Object)file.getFileName());
        } else {
            HotFolderAdapter.LOG.trace("Could not acquire Lock for {}", (Object)file.getFileName());
        }
        return acquired;
    }

    private void releaseExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        String lockFileName = LockStrategy.getLockFileName(file);
        File lock = new File(lockFileName);
        FileUtil.deleteFile((File)lock);
    }

    public void setTimeout(long timeout) {
    }

    public void setCheckInterval(long checkInterval) {
    }

    private static void deleteLockFiles(File dir, boolean recursive) {
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        for (File file : files) {
            if (file.getName().startsWith(".")) continue;
            if (file.getName().endsWith(".lock")) {
                FileUtil.deleteFile((File)file);
                continue;
            }
            if (!recursive || !file.isDirectory()) continue;
            LockStrategy.deleteLockFiles(file, true);
        }
    }

    private static String getLockFileName(GenericFile<File> file) {
        return file.getAbsoluteFilePath() + ".lock";
    }

    public void releaseExclusiveReadLockOnAbort(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        this.releaseExclusiveReadLock(operations, file, exchange);
    }

    public void releaseExclusiveReadLockOnRollback(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        this.releaseExclusiveReadLock(operations, file, exchange);
    }

    public void releaseExclusiveReadLockOnCommit(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        this.releaseExclusiveReadLock(operations, file, exchange);
    }

    public void setReadLockLoggingLevel(LoggingLevel readLockLoggingLevel) {
    }

    public void setMarkerFiler(boolean markerFile) {
    }

    public void setDeleteOrphanLockFiles(boolean deleteOrphanLockFiles) {
    }
}

