/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.hotfolder.support;

import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderUtil;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.support.CustomNameBuilder;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.support.IHotFolderFilenameStrategy;
import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import de.pontonconsulting.xmlpipe.message.BackEndMessageException;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractHotFolderFilenameStrategy
implements IHotFolderFilenameStrategy {
    private final CustomNameBuilder _pathBuilder;
    private String extension;
    private String prefix;

    public AbstractHotFolderFilenameStrategy(CustomNameBuilder pathBuilder) {
        this._pathBuilder = pathBuilder;
    }

    public AbstractHotFolderFilenameStrategy(CustomNameBuilder pathBuilder, String prefix, String extension) {
        this._pathBuilder = pathBuilder;
        this.prefix = prefix;
        this.extension = extension;
    }

    protected String getFolder(BackEndMessage message) throws BackEndMessageException {
        return this._pathBuilder.build(message);
    }

    protected abstract File onGetFile(BackEndMessage var1) throws BackEndMessageException;

    protected final File preGetFile(File file, BackEndMessage message) {
        if (this.prefix != null) {
            String filePath = FilenameUtils.getFullPath((String)file.getAbsolutePath());
            StringBuilder buffer = new StringBuilder(filePath);
            String fileName = FilenameUtils.getName((String)file.getAbsolutePath());
            if (StringUtils.isNotBlank((CharSequence)this.prefix)) {
                buffer.append(this.prefix).append("-");
            }
            buffer.append(fileName);
            return new File(buffer.toString());
        }
        return file;
    }

    @Override
    public File getFile(BackEndMessage message) throws BackEndMessageException {
        File file = this.onGetFile(message);
        if (file != null) {
            file = this.preGetFile(file, message);
            file = this.postGetFile(file, message);
        }
        return file;
    }

    protected final File postGetFile(File file, BackEndMessage message) {
        if (this.extension != null) {
            StringBuilder buffer = new StringBuilder(file.getAbsolutePath());
            if (StringUtils.isNotBlank((CharSequence)this.extension)) {
                if (!this.extension.startsWith(".")) {
                    buffer.append(".");
                }
                buffer.append(this.extension);
            }
            return new File(buffer.toString());
        }
        return file;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public synchronized void createParentFolders(BackEndMessage message) throws BackEndMessageException {
        String folderPath = this._pathBuilder.build(message);
        folderPath = folderPath.replace('\\', '/');
        HotFolderUtil.createDirectoryIfNotExsists(new File(folderPath));
    }
}

