/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.hotfolder.config;

import de.pontonconsulting.xmlpipe.adapter.hotfolder.config.HotFolderConfiguration;
import de.pontonconsulting.xmlpipe.config.hotfolder.FileProcessing;
import de.pontonconsulting.xmlpipe.config.hotfolder.HotFolderConfig;
import de.pontonconsulting.xmlpipe.config.hotfolder.ObjectFactory;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;

public class HotFolderCfg {
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    public static final char[] INVALID_CHARS_FOR_FILE_PATH = new char[]{'*', ',', ';', ':', '?', '!', '\"', '\'', '<', '>', '|'};
    public static final char[] INVALID_CHARS_FOR_FILENAME_PATTERN = new char[]{'*', '/', '\\', ',', ';', ':', '?', '!', '\"', '\'', '<', '>', '|'};
    public static final char[] INVALID_CHARS_FOR_FILE_EXTENSION = new char[]{'*', '.', '/', '\\', ',', ';', ':', '?', '!', '\"', '\'', '<', '>', '|'};
    protected static final String[] DEFAULT_ACCEPTED_EXTENSIONS = new String[]{"xml", "edi", "x12", "bin"};
    public static final List<String> DEFAULT_ACCEPTED_EXTENSIONS_LIST = Arrays.asList(DEFAULT_ACCEPTED_EXTENSIONS);
    private final HotFolderConfiguration _parent;
    private final int _folderNumber;

    public HotFolderCfg(HotFolderConfiguration config, int folderNumber) {
        this._folderNumber = folderNumber;
        this._parent = config;
    }

    public int getAdapterPort() throws JAXBException {
        Integer value = this.getConfiguration().getAdapterPort();
        return value != null ? value : 0;
    }

    public void setAdapterPort(int adapterPort) throws JAXBException {
        this.getConfiguration().setAdapterPort(Integer.valueOf(adapterPort));
    }

    public void removeAdapterPort() throws JAXBException {
        HotFolderConfig.HotFolder hf = this.getConfiguration();
        HotFolderConfig.HotFolder newHf = OBJECT_FACTORY.createHotFolderConfigHotFolder();
        newHf.setReceiveFormat(hf.getReceiveFormat());
        newHf.setSaveWithBackEndEnvelope(hf.isSaveWithBackEndEnvelope());
        newHf.setSupportsAttachments(hf.isSupportsAttachments());
        newHf.setFolders(hf.getFolders());
        newHf.setNumberOfReceivingThreads(hf.getNumberOfReceivingThreads());
        newHf.setAdapterID(hf.getAdapterID());
        newHf.setUsePartnerSubfolders(hf.isUsePartnerSubfolders());
        newHf.setSenderLocalID(hf.getSenderLocalID());
        newHf.setReceiveFilenameFormat(hf.getReceiveFilenameFormat());
        newHf.setReceiveFilenameFormat(hf.getReceiveFilenameFormat());
        newHf.setReceiveFilenamePattern(hf.getReceiveFilenamePattern());
        this._parent.setHotFolderType(this._folderNumber, newHf);
    }

    public String getAdapterID() throws JAXBException {
        return this.getConfiguration().getAdapterID();
    }

    public void setAdapterID(String adapterID) throws JAXBException {
        this.getConfiguration().setAdapterID(adapterID);
    }

    public String getReceiveFormat() throws JAXBException {
        return this.getConfiguration().getReceiveFormat().value();
    }

    public boolean getUsePartnerSubfolders() throws JAXBException {
        Boolean temp = this.getConfiguration().isUsePartnerSubfolders();
        if (temp == null) {
            return false;
        }
        return temp;
    }

    public void setUsePartnerSubfolders(boolean usePartnerSubfolders) throws JAXBException {
        this.getConfiguration().setUsePartnerSubfolders(Boolean.valueOf(usePartnerSubfolders));
    }

    public boolean getSupportsAttachments() throws JAXBException {
        return this.getConfiguration().isSupportsAttachments();
    }

    public void setSupportsAttachments(boolean supportsAttachments) throws JAXBException {
        this.getConfiguration().setSupportsAttachments(supportsAttachments);
    }

    public String getSenderLocalID() throws JAXBException {
        return this.getConfiguration().getSenderLocalID();
    }

    public void setSenderLocalID(String senderLocalID) throws JAXBException {
        this.getConfiguration().setSenderLocalID(senderLocalID);
    }

    public String getInbox() throws JAXBException {
        return this.getConfiguration().getFolders().getInbox();
    }

    public void setInbox(String inbox) throws JAXBException {
        this.getConfiguration().getFolders().setInbox(inbox);
    }

    public String getOutbox() throws JAXBException {
        return this.getConfiguration().getFolders().getOutbox().getValue();
    }

    public File getOutboxFolder() throws JAXBException {
        return this.getRealFolder(this.getOutbox());
    }

    public void setOutbox(String outbox) throws JAXBException {
        this.getConfiguration().getFolders().getOutbox().setValue(outbox);
    }

    public String getFailed() throws JAXBException {
        return this.getConfiguration().getFolders().getFailed();
    }

    public File getFailedFolder() throws JAXBException {
        return this.getRealFolder(this.getFailed());
    }

    public void setFailed(String failed) throws JAXBException {
        this.getConfiguration().getFolders().setFailed(failed);
    }

    public String getWork() throws JAXBException {
        return this.getConfiguration().getFolders().getWork();
    }

    public File getWorkFolder() throws JAXBException {
        return this.getRealFolder(this.getWork());
    }

    public void setWork(String work) throws JAXBException {
        this.getConfiguration().getFolders().setWork(work);
    }

    public long getScanInterval() throws JAXBException {
        return this.getConfiguration().getFolders().getScanInterval();
    }

    public void setScanInterval(long interval) throws JAXBException {
        this.getConfiguration().getFolders().setScanInterval(interval);
    }

    public boolean isERPAcknowledgementEnabled() throws JAXBException {
        HotFolderConfig.HotFolder.Folders.ERPAcknowledgement erpAck = this.getConfiguration().getFolders().getERPAcknowledgement();
        if (erpAck == null) {
            return false;
        }
        return erpAck.isEnabled();
    }

    public boolean getUseERPAcknowledgementSubfolder() throws JAXBException {
        HotFolderConfig.HotFolder.Folders.ERPAcknowledgement erpAck = this.getConfiguration().getFolders().getERPAcknowledgement();
        if (erpAck == null) {
            return false;
        }
        return erpAck.isUseSubfolder();
    }

    public void setERPAcknowledgementEnabled(boolean enable) throws JAXBException {
        HotFolderConfig.HotFolder.Folders.ERPAcknowledgement erpAck = this.getConfiguration().getFolders().getERPAcknowledgement();
        if (erpAck == null) {
            erpAck = OBJECT_FACTORY.createHotFolderConfigHotFolderFoldersERPAcknowledgement();
            erpAck.setEnabled(enable);
            this.getConfiguration().getFolders().setERPAcknowledgement(erpAck);
        } else {
            this.getConfiguration().getFolders().getERPAcknowledgement().setEnabled(enable);
        }
    }

    public String getERPInbox() throws JAXBException {
        HotFolderConfig.HotFolder.Folders.ERPAcknowledgement erpAck = this.getConfiguration().getFolders().getERPAcknowledgement();
        if (erpAck == null) {
            return null;
        }
        return erpAck.getInbox();
    }

    public File getERPInboxFolder() throws JAXBException {
        return this.getRealFolder(this.getERPInbox());
    }

    public File getRealFolder(String path) {
        return this._parent.getFolder(path);
    }

    public String getRealPath(String path) {
        try {
            return this._parent.getRealPath(path);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setERPInbox(String erpInbox) throws JAXBException {
        HotFolderConfig.HotFolder.Folders.ERPAcknowledgement erpAck = this.getConfiguration().getFolders().getERPAcknowledgement();
        if (erpAck == null) {
            erpAck = OBJECT_FACTORY.createHotFolderConfigHotFolderFoldersERPAcknowledgement();
            erpAck.setInbox(erpInbox);
            this.getConfiguration().getFolders().setERPAcknowledgement(erpAck);
        } else {
            this.getConfiguration().getFolders().getERPAcknowledgement().setInbox(erpInbox);
        }
    }

    public int getNumberOfReceivingThreads() throws JAXBException {
        return this.getConfiguration().getNumberOfReceivingThreads();
    }

    public void setNumberOfReceivingThreads(int numberOfReceivingThreads) throws JAXBException {
        this.getConfiguration().setNumberOfReceivingThreads(numberOfReceivingThreads);
    }

    public int getNumberOfSendingThreads() throws JAXBException {
        Integer value = this.getConfiguration().getNumberOfSendingThreads();
        return value != null ? value : 3;
    }

    public void setNumberOfSendingThreads(int numberOfSendingThreads) throws JAXBException {
        this.getConfiguration().setNumberOfSendingThreads(Integer.valueOf(numberOfSendingThreads));
    }

    public boolean getSaveWithBackEndEnvelope() throws JAXBException {
        return this.getConfiguration().isSaveWithBackEndEnvelope();
    }

    public void setSaveWithBackEndEnvelope(boolean saveWithBackEndEnvelope) throws JAXBException {
        this.getConfiguration().setSaveWithBackEndEnvelope(saveWithBackEndEnvelope);
    }

    private HotFolderConfig.HotFolder getConfiguration() throws JAXBException {
        return this._parent.getHotFolderConfigHotFolder(this._folderNumber);
    }

    public List<String> getAcceptedFileExtensions() throws JAXBException {
        List list = this.getConfiguration().getAcceptedFileExtensions();
        if (list == null || list.size() == 0) {
            return DEFAULT_ACCEPTED_EXTENSIONS_LIST;
        }
        return new ArrayList<String>(list);
    }

    public String[] getAcceptedFileExtensionsArray() throws JAXBException {
        return this.getAcceptedFileExtensions().toArray(new String[this.getAcceptedFileExtensions().size()]);
    }

    public void setAcceptedFileExtension(List<String> acceptedFileExtensions) throws JAXBException {
        if (acceptedFileExtensions == null || acceptedFileExtensions.isEmpty()) {
            return;
        }
        this.getConfiguration().getAcceptedFileExtensions().clear();
        CollectionUtils.filter(acceptedFileExtensions, (Predicate)new Predicate(this){

            public boolean evaluate(Object object) {
                return StringUtils.isNotBlank((CharSequence)((String)object)) && StringUtils.containsNone((CharSequence)((String)object), (char[])INVALID_CHARS_FOR_FILE_EXTENSION);
            }
        });
        Collections.sort(acceptedFileExtensions, String::compareToIgnoreCase);
        for (String extension : acceptedFileExtensions) {
            this.addAcceptedFileExtension(extension);
        }
    }

    public void setAcceptedFileExceptions(String[] accepedFileExtensions) throws JAXBException {
        this.getConfiguration().getAcceptedFileExtensions().clear();
        for (int i = 0; i < accepedFileExtensions.length; ++i) {
            this.addAcceptedFileExtension(accepedFileExtensions[i]);
        }
    }

    public void addAcceptedFileExtension(String accepedFileExtension) throws JAXBException {
        if (StringUtils.isBlank((CharSequence)accepedFileExtension)) {
            return;
        }
        this.getConfiguration().getAcceptedFileExtensions().add(accepedFileExtension);
    }

    public String getFileNamePattern() throws JAXBException {
        String result = this.getConfiguration().getReceiveFilenamePattern();
        if (StringUtils.isBlank((CharSequence)result)) {
            result = this._parent.getDefaultReceiveFilenamePattern();
        }
        return result;
    }

    public void setFileNamePattern(String pattern) throws JAXBException {
        this.getConfiguration().setReceiveFilenamePattern(pattern);
    }

    public boolean isFileProcessingAutodetectionEnabled() throws JAXBException {
        return this.getConfiguration().getFolders().getOutbox().getFileProcessing().equals((Object)FileProcessing.AUTODETECT);
    }

    public String getFileProcessing() throws JAXBException {
        return this.getConfiguration().getFolders().getOutbox().getFileProcessing().value();
    }

    public void setFileProcessing(String fileProcessing) throws JAXBException {
        this.getConfiguration().getFolders().getOutbox().setFileProcessing(FileProcessing.fromValue((String)fileProcessing));
    }

    public Integer getMinFileAge() throws JAXBException {
        return this.getConfiguration().getMinimumAge();
    }

    public void setMinFileAge(Integer minAge) throws JAXBException {
        this.getConfiguration().setMinimumAge(minAge);
    }

    public void save() {
        this.save("SYSTEM");
    }

    public void save(String username) {
        try {
            this._parent.save(username);
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
    }
}

