/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.hotfolder;

import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderAdapter;
import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;

public class HotFolderUtil {
    public static final String ACK_PREFIX = "ACK";
    public static final String XML_EXT = "xml";
    public static final String DOT_XML_EXT = ".xml";
    public static final String TEMP_EXTENSION = ".hfa";
    public static final String LOCK_EXTENSION = ".lock";

    public static String getAckFilename(BackEndMessage message, String prefix, String suffix) {
        if (message == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)prefix)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)suffix)) {
            return null;
        }
        String refId = null;
        refId = StringUtils.isBlank((CharSequence)message.getDatabaseId()) ? message.getReferenceId() : message.getDatabaseId();
        StringBuilder result = new StringBuilder(prefix);
        String fileNameOrMId = StringUtils.isNotBlank((CharSequence)message.getProcessingDirectiveAsString("OriginalFilename")) ? message.getProcessingDirectiveAsString("OriginalFilename") : refId;
        result.append("-").append(fileNameOrMId).append(suffix);
        return result.toString();
    }

    public static void createDirectoryIfNotExsists(File folder) {
        if (folder == null) {
            return;
        }
        if (folder.exists() && folder.isDirectory()) {
            return;
        }
        try {
            FileUtils.forceMkdir((File)folder);
        }
        catch (Exception ex) {
            HotFolderAdapter.LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public static File mkDir(boolean isSubfolder, File folder, String subfolder) {
        File baseInDir;
        if (isSubfolder) {
            baseInDir = new File(folder, subfolder);
            HotFolderUtil.createDirectoryIfNotExsists(baseInDir);
        } else {
            baseInDir = folder;
        }
        return baseInDir;
    }

    public static void deleteDir(File folder, String remotePartnerId) {
        File folderToDelete;
        if (folder != null && StringUtils.isNotBlank((CharSequence)remotePartnerId) && folder.exists() && folder.isDirectory() && (folderToDelete = new File(folder, remotePartnerId)).exists() && folderToDelete.isDirectory() && !folderToDelete.delete()) {
            HotFolderAdapter.LOG.warn("Could not delete unused folder '{}'.", (Object)folderToDelete.getAbsolutePath());
        }
    }

    public static void logError(Logger log, Throwable ex) {
        if (log != null) {
            log.error((Object)ex);
        } else {
            HotFolderAdapter.LOG.error((Object)ex);
        }
    }

    public static void logError(Logger log, String ex) {
        if (log != null) {
            log.error(ex);
        } else {
            HotFolderAdapter.LOG.error(ex);
        }
    }

    public static void logInfo(Logger log, String text) {
        if (log != null) {
            log.info(text);
        } else {
            HotFolderAdapter.LOG.info(text);
        }
    }

    public static void logWarn(Logger log, String text) {
        if (log != null) {
            log.warn(text);
        } else {
            HotFolderAdapter.LOG.warn(text);
        }
    }

    public static File getAttachmentFolder(File file) {
        return new File(FilenameUtils.concat((String)file.getParentFile().getAbsolutePath(), (String)HotFolderUtil.getAttachmenFolderName(file.getName())));
    }

    public static File getAttachmentFolder(String fileParent, String fileName) {
        return new File(FilenameUtils.concat((String)fileParent, (String)HotFolderUtil.getAttachmenFolderName(fileName)));
    }

    private static String getAttachmenFolderName(String fileName) {
        return StringUtils.trim((String)FilenameUtils.getBaseName((String)fileName));
    }
}

