/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.hotfolder;

import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderAdapter;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.config.HotFolderCfg;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.config.HotFolderConfiguration;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.support.HotFolderFileFilter;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.support.LockStrategy;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileFilter;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ThreadsDefinition;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.internal.StringUtil;
import org.springframework.util.Assert;

public class HotFolderOutboundRouteBuilder
extends RouteBuilder {
    private final HotFolderConfiguration hotfolderConfiguration;

    public HotFolderOutboundRouteBuilder(HotFolderConfiguration hotfolderConfiguration) {
        this.hotfolderConfiguration = hotfolderConfiguration;
    }

    public void configure() throws Exception {
        HashMap<File, String> validOutboxes = new HashMap<File, String>();
        for (String hotfolderId : this.hotfolderConfiguration.getHotFolderIDs()) {
            HotFolderAdapter.LOG.info("Building Outbound Processor for {}", (Object)hotfolderId);
            try {
                HotFolderCfg hotfolder = this.hotfolderConfiguration.getHotFolder(hotfolderId);
                if (hotfolder.getUsePartnerSubfolders()) {
                    Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)hotfolder.getSenderLocalID()), (String)("No Sender Local Id set for the Hotfolder Adapter '" + hotfolderId + "'."));
                }
                FileEndpoint hotfolderEndpoint = this.createMessageEndpoint(hotfolder, validOutboxes);
                FileEndpoint failedMessageEndpoint = this.createFailedMessageEndpoint(hotfolder);
                String senderLocalID = hotfolder.getSenderLocalID();
                ThreadsDefinition tDefinition = this.from((Endpoint)hotfolderEndpoint).errorHandler((ErrorHandlerFactory)this.deadLetterChannel((Endpoint)failedMessageEndpoint).disableRedelivery().log("HotFolder.ErrorHandler").loggingLevel(LoggingLevel.ERROR).onExceptionOccurred(exchange -> {
                    Exception e = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
                    if (Objects.nonNull(e)) {
                        HotFolderAdapter.LOG.error("{}.ErrorHandler({}) caught {}, cased by {}, occurred while processing {}: {}", (Object)"HotFolder", (Object)hotfolderId, (Object)e.getClass().getCanonicalName(), (Object)e.getCause().getClass().getCanonicalName(), exchange.getIn().getHeader("CamelFileName"), (Object)e.getMessage(), (Object)e);
                        if (e.getCause() instanceof Error) {
                            System.err.println("HotFolder.ErrorHandler(" + hotfolderId + ") caught " + e.getCause().getClass().getCanonicalName());
                        }
                    }
                })).threads(hotfolder.getNumberOfSendingThreads(), hotfolder.getNumberOfSendingThreads());
                tDefinition.process(exchange -> exchange.getIn().setHeader("HotfolderConfig", (Object)hotfolder));
                if (!StringUtil.isBlank((String)senderLocalID)) {
                    tDefinition.process(exchange -> {
                        String fileParent = (String)exchange.getIn().getHeader("CamelFileParent");
                        String receiverLocalId = HotFolderOutboundRouteBuilder.getLastFolder(fileParent);
                        exchange.getIn().setHeader("ReceiverLocalId", (Object)receiverLocalId);
                    });
                }
                if (hotfolder.isFileProcessingAutodetectionEnabled()) {
                    ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)tDefinition.choice().when().simple("${file:name} regex '.*(?i)(\\.xml$)'")).bean((Object)"hotfolder", "handleXmlMessage")).when().simple("${file:name} regex '.*(?i)(\\.edi$)'")).bean((Object)"hotfolder", "handleEdiMessage")).when().simple("${file:name} regex '.*(?i)(\\.x12$)'")).bean((Object)"hotfolder", "handleX12Message")).otherwise().bean((Object)"hotfolder", "handleBinMessage");
                    continue;
                }
                String handleMethod = this.getHandleMethode(hotfolder.getFileProcessing());
                tDefinition.bean((Object)"hotfolder", handleMethod);
            }
            catch (Exception e) {
                HotFolderAdapter.LOG.error("Cannot configure HotFolderOutboundRouteBuilder: {}", (Object)e.toString());
            }
        }
    }

    public static String getLastFolder(String path) {
        String reverted = StringUtils.reverse((String)StringUtils.strip((String)path, (String)File.separator));
        String[] revertedArray = StringUtils.split((String)reverted, (char)File.separatorChar);
        if (revertedArray == null || revertedArray.length < 1) {
            return null;
        }
        String revertedResult = revertedArray[0];
        return StringUtils.reverse((String)revertedResult);
    }

    private String getHandleMethode(String fixedFileType) {
        if ("XML".equalsIgnoreCase(fixedFileType)) {
            return "handleXmlMessage";
        }
        if ("EDI".equalsIgnoreCase(fixedFileType)) {
            return "handleEdiMessage";
        }
        if ("X12".equalsIgnoreCase(fixedFileType)) {
            return "handleX12Message";
        }
        return "handleBinMessage";
    }

    private FileEndpoint createFailedMessageEndpoint(HotFolderCfg hotfolder) throws JAXBException {
        FileEndpoint deadLetterEndpoint = new FileEndpoint();
        deadLetterEndpoint.setFile(hotfolder.getFailedFolder());
        deadLetterEndpoint.setCamelContext(this.getContext());
        deadLetterEndpoint.setExchangePattern(ExchangePattern.InOut);
        deadLetterEndpoint.setFileName("${file:name}");
        return deadLetterEndpoint;
    }

    FileEndpoint createMessageEndpoint(HotFolderCfg hotfolder, Map<File, String> validOutboxes) throws JAXBException {
        FileEndpoint hotfolderEndpoint = new FileEndpoint();
        if (hotfolder.getUsePartnerSubfolders()) {
            hotfolderEndpoint.setRecursive(true);
        }
        File outboxFolder = hotfolder.getOutboxFolder();
        Assert.notNull((Object)outboxFolder, (String)("No outbox folder defined for the Hotfolder Adapter '" + hotfolder.getAdapterID() + "'."));
        File outboxFolderAbsolute = outboxFolder.getAbsoluteFile();
        String validAdapterId = validOutboxes.get(outboxFolderAbsolute);
        Assert.isNull((Object)validAdapterId, (String)("The outbox folder of the Hotfolder Adapter '" + hotfolder.getAdapterID() + "' is already used by the Hotfolder Adapter '" + validAdapterId + "'."));
        Assert.isTrue((boolean)outboxFolderAbsolute.exists(), (String)"Outboxfolder does not exist");
        Assert.isTrue((boolean)outboxFolderAbsolute.isDirectory(), (String)"Outboxfolder is not a directory");
        Assert.isTrue((boolean)outboxFolderAbsolute.canRead(), (String)"Outboxfolder cannot read");
        Assert.isTrue((boolean)outboxFolderAbsolute.canWrite(), (String)"Outboxfolder cannot write");
        FileExtensionRegexBuilder extBuilder = new FileExtensionRegexBuilder(this, hotfolder, outboxFolderAbsolute);
        hotfolderEndpoint.setFile(outboxFolderAbsolute);
        hotfolderEndpoint.setCamelContext(this.getContext());
        hotfolderEndpoint.setDelete(true);
        hotfolderEndpoint.setExchangePattern(ExchangePattern.InOnly);
        hotfolderEndpoint.setFilter(extBuilder.build());
        hotfolderEndpoint.setDelay(hotfolder.getScanInterval() * 1000L);
        hotfolderEndpoint.setUseFixedDelay(false);
        hotfolderEndpoint.setExclusiveReadLockStrategy((GenericFileExclusiveReadLockStrategy)new LockStrategy());
        hotfolderEndpoint.setReadLockTimeout(2000L);
        hotfolderEndpoint.setIdempotent(Boolean.FALSE);
        hotfolderEndpoint.setIdempotentEager(Boolean.FALSE);
        hotfolderEndpoint.setSortBy("file:modified");
        validOutboxes.put(outboxFolderAbsolute, hotfolder.getAdapterID());
        return hotfolderEndpoint;
    }

    private class FileExtensionRegexBuilder {
        private final Set<String> extensions = new HashSet<String>();
        private final File baseFolder;
        private boolean subdir;
        private Integer minAge;

        public FileExtensionRegexBuilder(HotFolderOutboundRouteBuilder hotFolderOutboundRouteBuilder, HotFolderCfg hotfolder, File baseFolder) {
            try {
                this.subdir = hotfolder.getUsePartnerSubfolders();
                this.minAge = hotfolder.getMinFileAge();
                if (hotfolder.getAcceptedFileExtensions() == null || hotfolder.getAcceptedFileExtensions().isEmpty()) {
                    this.add(HotFolderCfg.DEFAULT_ACCEPTED_EXTENSIONS_LIST);
                } else {
                    this.add(hotfolder.getAcceptedFileExtensions());
                }
            }
            catch (JAXBException ex) {
                this.add(HotFolderCfg.DEFAULT_ACCEPTED_EXTENSIONS_LIST);
                HotFolderAdapter.LOG.error(ex.getMessage());
            }
            this.baseFolder = baseFolder;
        }

        private void add(List<String> extensionValues) {
            for (String extension : extensionValues) {
                this.extensions.add(extension.toLowerCase());
            }
        }

        public GenericFileFilter<File> build() {
            HotFolderFileFilter<File> filter = new HotFolderFileFilter<File>();
            filter.setBaseFolder(this.baseFolder);
            filter.setSubdir(this.subdir);
            filter.setMinAge(this.minAge);
            for (String ext : this.extensions) {
                filter.addExtension(ext);
            }
            return filter;
        }
    }
}

