/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.hotfolder;

import de.pontonconsulting.xmlpipe.adapter.AdapterException;
import de.pontonconsulting.xmlpipe.adapter.IAgreementEventListener;
import de.pontonconsulting.xmlpipe.adapter.IPartnerEventListener;
import de.pontonconsulting.xmlpipe.adapter.ISpecificAdapter;
import de.pontonconsulting.xmlpipe.adapter.MessageResult;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderInboundHandler;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderUtil;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.config.HotFolderCfg;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.support.AbstractHotFolderFilenameStrategy;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.support.HotFolderCustomNameStrategy;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.support.HotFolderOriginalFileNameStrategy;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.support.IHotFolderFilenameStrategy;
import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import de.pontonconsulting.xmlpipe.message.BackEndMessageException;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.Assert;

public class HotFolderDelegate
implements ISpecificAdapter,
IAgreementEventListener,
IPartnerEventListener {
    private final HotFolderInboundHandler inboundHandler;
    private String id;
    private int parallelThread;
    private File workFolder;
    private boolean supportAcknowledgements;
    private boolean supportAttachments;
    private HotFolderCfg hotfolderCfg;
    private Logger log;
    private final AtomicInteger numberOfReceivedMessages = new AtomicInteger();
    private final AtomicInteger numberOfReceivedFailed = new AtomicInteger();
    private final AtomicInteger numberOfReceivedAckMessages = new AtomicInteger();

    public HotFolderDelegate(HotFolderInboundHandler inboundHandler, HotFolderCfg hotfolderCfg) {
        this.inboundHandler = inboundHandler;
        try {
            this.id = hotfolderCfg.getAdapterID();
            this.parallelThread = hotfolderCfg.getNumberOfReceivingThreads();
            this.workFolder = hotfolderCfg.getWorkFolder();
            this.supportAcknowledgements = hotfolderCfg.isERPAcknowledgementEnabled();
            this.supportAttachments = hotfolderCfg.getSupportsAttachments();
            this.hotfolderCfg = hotfolderCfg;
            this.initializeLogger();
        }
        catch (Exception ex) {
            HotFolderUtil.logError(this.log, ex);
        }
    }

    public void agreementAdded(String localPartnerId, String remotePartnerId) {
        if (this.isUsedSender(localPartnerId)) {
            try {
                HotFolderUtil.mkDir(true, this.hotfolderCfg.getOutboxFolder(), remotePartnerId);
            }
            catch (Exception ex) {
                HotFolderUtil.logError(this.log, ex);
            }
        } else if (this.isUsedSender(remotePartnerId)) {
            try {
                HotFolderUtil.mkDir(true, this.hotfolderCfg.getOutboxFolder(), localPartnerId);
            }
            catch (Exception ex) {
                HotFolderUtil.logError(this.log, ex);
            }
        }
    }

    public void agreementDeleted(String localPartnerId, String remotePartnerId) {
        if (this.isUsedSender(localPartnerId)) {
            try {
                HotFolderUtil.deleteDir(this.hotfolderCfg.getOutboxFolder(), remotePartnerId);
            }
            catch (Exception ex) {
                HotFolderUtil.logError(this.log, ex);
            }
        } else if (this.isUsedSender(remotePartnerId)) {
            try {
                HotFolderUtil.deleteDir(this.hotfolderCfg.getOutboxFolder(), localPartnerId);
            }
            catch (Exception ex) {
                HotFolderUtil.logError(this.log, ex);
            }
        }
    }

    public void agreementModified(String localPartnerId, String remotePartnerId) {
    }

    private boolean isUsedSender(String senderId) {
        try {
            if (this.hotfolderCfg.getUsePartnerSubfolders()) {
                return StringUtils.equals((CharSequence)senderId, (CharSequence)this.hotfolderCfg.getSenderLocalID());
            }
        }
        catch (Exception ex) {
            HotFolderUtil.logError(this.log, ex);
        }
        return false;
    }

    public String getID() {
        return this.id;
    }

    public String getStatus() {
        return this.getHtmlStatus();
    }

    private String getHtmlStatus() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<font class=\"font\" id=\"normal\" >&nbsp;&nbsp;Status for HotFolder '").append(this.getID()).append("':</font><br>").append(this.getStatusHtmlPart()).append("<font class=\"font\" id=\"content\" >&nbsp;&nbsp;Received ").append(this.numberOfReceivedMessages.get()).append(" Messages (Failed ").append(this.numberOfReceivedFailed.get()).append(")").append("</font>\n").append("<br>").append("<font class=\"font\" id=\"content\" >&nbsp;&nbsp;Received ").append(this.numberOfReceivedAckMessages.get()).append(" Acknowledgments.</font>\n");
        return buffer.toString();
    }

    private String getStatusHtmlPart() {
        String status = "";
        try {
            StringBuilder buffer = new StringBuilder();
            buffer.append("<font class=\"font\" id=\"content\" ><br>&nbsp;&nbsp;&nbsp;&nbsp;").append("Processor-").append(this.hotfolderCfg.getOutboxFolder().getAbsolutePath()).append(":").append("<br></font>\n");
            status = buffer.toString();
        }
        catch (Exception ex) {
            HotFolderUtil.logError(this.log, ex);
        }
        return status;
    }

    public boolean supportsAcknowledgements() {
        return this.supportAcknowledgements;
    }

    public boolean supportsAttachments() {
        return this.supportAttachments;
    }

    public int getNumberOfParallelThreads() {
        return this.parallelThread;
    }

    public MessageResult receiveMessage(BackEndMessage message) {
        this.logInput(message);
        this.numberOfReceivedMessages.incrementAndGet();
        IHotFolderFilenameStrategy strategy = null;
        try {
            strategy = this.createStrategyAndParentFolders(message);
        }
        catch (Exception e) {
            String errorText = "Could not build file path for the receiving message: " + e.toString();
            HotFolderUtil.logError(this.log, errorText);
            MessageResult messageResult = new MessageResult(MessageResult.ADAPTER_REJECTED_MESSAGE);
            messageResult.appendToDescription(errorText);
            return messageResult;
        }
        try {
            MessageResult messageResult = this.inboundHandler.receiveMessage(this.log, this.hotfolderCfg, strategy, message);
            this.logOutput(false, messageResult, message);
            return messageResult;
        }
        catch (Exception e) {
            String errorText = e instanceof InterruptedException ? "Delivery to adapter was interrupted" : "Could not receive message: " + e.toString();
            HotFolderUtil.logError(this.log, errorText);
            MessageResult messageResult = new MessageResult(MessageResult.ADAPTER_REJECTED_MESSAGE);
            messageResult.appendToDescription(errorText);
            return messageResult;
        }
    }

    public MessageResult receiveTestMessage(BackEndMessage message) {
        this.logInput(message);
        this.numberOfReceivedMessages.incrementAndGet();
        IHotFolderFilenameStrategy strategy = null;
        try {
            strategy = this.createStrategyAndParentFolders(message);
        }
        catch (Exception e) {
            String errorText = "Could not build file path for the receiving test message: " + e.toString();
            HotFolderUtil.logError(this.log, errorText);
            MessageResult messageResult = new MessageResult(MessageResult.ADAPTER_REJECTED_MESSAGE);
            messageResult.appendToDescription(errorText);
            return messageResult;
        }
        try {
            MessageResult messageResult = this.inboundHandler.receiveTestMessage(this.log, this.hotfolderCfg, strategy, message);
            this.logOutput(false, messageResult, message);
            return messageResult;
        }
        catch (Exception e) {
            String errorText = "Could not receive test message: " + e.toString();
            HotFolderUtil.logError(this.log, errorText);
            MessageResult messageResult = new MessageResult(MessageResult.ADAPTER_REJECTED_MESSAGE);
            messageResult.appendToDescription(errorText);
            return messageResult;
        }
    }

    public MessageResult receiveAcknowledgement(BackEndMessage message) {
        this.logInput(message);
        this.numberOfReceivedAckMessages.incrementAndGet();
        IHotFolderFilenameStrategy strategy = null;
        try {
            strategy = this.createStrategyAndParentFolders(message);
        }
        catch (Exception e) {
            String errorText = "Could not build file path for the receiving ACK: " + e.toString();
            HotFolderUtil.logError(this.log, errorText);
            MessageResult messageResult = new MessageResult(MessageResult.ADAPTER_REJECTED_MESSAGE);
            messageResult.appendToDescription(errorText);
            return messageResult;
        }
        try {
            MessageResult messageResult = this.inboundHandler.receiveAcknowledgement(this.log, this.hotfolderCfg, strategy, message);
            this.logOutput(false, messageResult, message);
            return messageResult;
        }
        catch (Exception e) {
            String errorText = "Could not receive ACK: " + e.toString();
            HotFolderUtil.logError(this.log, errorText);
            MessageResult messageResult = new MessageResult(MessageResult.ADAPTER_REJECTED_MESSAGE);
            messageResult.appendToDescription(errorText);
            return messageResult;
        }
    }

    private IHotFolderFilenameStrategy createStrategyAndParentFolders(BackEndMessage message) throws BackEndMessageException, IllegalArgumentException, JAXBException {
        AbstractHotFolderFilenameStrategy strategy = null;
        if (message.isAcknowledgement()) {
            String ackFolder = this.hotfolderCfg.getERPInbox();
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)ackFolder), (String)"XML Inbox was null.");
            ackFolder = this.hotfolderCfg.getRealPath(ackFolder);
            strategy = new HotFolderOriginalFileNameStrategy(ackFolder, "ACK", ".xml");
            strategy.createParentFolders(message);
        } else {
            String inboxPattern = this.hotfolderCfg.getInbox();
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)inboxPattern), (String)"Inbox Pattern is an important precondition. Inbox Pattern was null.");
            inboxPattern = this.hotfolderCfg.getRealPath(inboxPattern);
            String filenamePattern = this.hotfolderCfg.getFileNamePattern();
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)filenamePattern), (String)"Filename Pattern is an important precondition. Filename Pattern was null.");
            strategy = new HotFolderCustomNameStrategy(inboxPattern, filenamePattern);
            strategy.createParentFolders(message);
        }
        return strategy;
    }

    public File getWorkFolder() {
        return this.workFolder;
    }

    public boolean doSelfCheck() {
        return true;
    }

    public String shutdown() {
        return "";
    }

    public void partnerAdded(String partnerId, String displayName, boolean isLocalPartner) {
    }

    public void partnerDeleted(String partnerId, String displayName, boolean isLocalPartner) {
    }

    public void partnerModified(String partnerId, String oldPartnerId, String displayName, boolean isLocalPartner) {
        try {
            if (this.hotfolderCfg.getUsePartnerSubfolders() && !oldPartnerId.equals(partnerId)) {
                if (isLocalPartner) {
                    String myPartner = this.hotfolderCfg.getSenderLocalID();
                    if (oldPartnerId.equals(myPartner)) {
                        this.hotfolderCfg.setSenderLocalID(partnerId);
                        this.hotfolderCfg.save();
                    }
                } else {
                    File oldPartnerOutbox = new File(this.hotfolderCfg.getOutboxFolder(), oldPartnerId);
                    if (oldPartnerOutbox.exists() && oldPartnerOutbox.isDirectory()) {
                        File newPartnerOutbox = new File(this.hotfolderCfg.getOutboxFolder(), partnerId);
                        FileUtils.moveDirectoryToDirectory((File)oldPartnerOutbox, (File)newPartnerOutbox, (boolean)true);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage());
        }
    }

    private void initializeLogger() throws AdapterException {
        try {
            String category = "HotFolder." + this.hotfolderCfg.getAdapterID();
            this.log = LogManager.getLogger((String)category);
        }
        catch (JAXBException ex) {
            HotFolderUtil.logError(this.log, ex);
            throw new AdapterException("Could not initialize the logger.", (Throwable)ex);
        }
    }

    private void logInput(BackEndMessage message) {
        HotFolderUtil.logInfo(this.log, String.format("Receiving message '%s' from: %s to %s", message.getTransferIDText(), message.getSenderOrganisationText(), message.getReceiverOrganisationText()));
    }

    private void logOutput(boolean isMessage, MessageResult receivedMessage, BackEndMessage message) {
        if (!receivedMessage.equals((Object)MessageResult.MSG_SUCCESSFULLY_RECEIVED)) {
            if (isMessage) {
                this.numberOfReceivedFailed.incrementAndGet();
            }
            HotFolderUtil.logError(this.log, String.format("Failed message '%s' cause: '%s' from: %s to %s", message.getTransferIDText(), receivedMessage.getDescription(), message.getSenderOrganisationText(), message.getReceiverOrganisationText()));
        }
    }
}

