/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.hotfolder;

import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolder;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderAdapter;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.HotFolderOutboundRouteBuilder;
import de.pontonconsulting.xmlpipe.adapter.hotfolder.config.HotFolderConfiguration;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.support.jndi.JndiBeanRepository;

public class HotFolderContextHolder {
    public static final String BEAN_NAME = "HotFolderContextHolder";
    private HotFolderConfiguration hotfolderConfiguration;
    private HotFolder hotfolderBean;
    private final AtomicReference<CamelContext> context = new AtomicReference();

    public void stopContext() {
        HotFolderAdapter.LOG.info("Stopping Hotfolder Context.");
        CamelContext camelContext = this.getContext();
        if (camelContext != null) {
            try {
                for (Route route : camelContext.getRoutes()) {
                    camelContext.getRouteController().stopRoute(route.getRouteId());
                }
                camelContext.stop();
            }
            catch (Exception ex) {
                HotFolderAdapter.LOG.error(ex.getMessage());
            }
        }
        this.setContext(null);
    }

    public void startContext() throws Exception {
        HotFolderAdapter.LOG.info("Starting Hotfolder Context.");
        try {
            HotFolderOutboundRouteBuilder routesBuilder = new HotFolderOutboundRouteBuilder(this.hotfolderConfiguration);
            JndiBeanRepository jndiContext = new JndiBeanRepository();
            DefaultCamelContext camelContext = new DefaultCamelContext((BeanRepository)jndiContext);
            camelContext.getExecutorServiceManager().setThreadNamePattern("HotFolder thread ##counter# - #name#");
            camelContext.getRegistry().bind("hotfolder", (Object)this.hotfolderBean);
            camelContext.disableJMX();
            this.setContext((CamelContext)camelContext);
            camelContext.addRoutes((RoutesBuilder)routesBuilder);
            camelContext.start();
            HotFolderAdapter.LOG.info("Hotfolder Context successfully started.");
        }
        catch (Exception ex) {
            HotFolderAdapter.LOG.error("Hotfolder Context init error");
            throw ex;
        }
    }

    public CamelContext getContext() {
        return this.context.get();
    }

    public void setContext(CamelContext context) {
        this.context.set(context);
    }

    public void setHotfolderConfiguration(HotFolderConfiguration hotfolderConfiguration) {
        this.hotfolderConfiguration = hotfolderConfiguration;
    }

    public HotFolder getHotfolderBean() {
        return this.hotfolderBean;
    }

    public void setHotfolderBean(HotFolder hotfolderBean) {
        this.hotfolderBean = hotfolderBean;
    }
}

