/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.as4certificateupdate;

import de.pontonconsulting.xmlpipe.adapter.AdapterException;
import de.pontonconsulting.xmlpipe.adapter.ExtendedGenericAdapter;
import de.pontonconsulting.xmlpipe.adapter.GenericAdapter;
import de.pontonconsulting.xmlpipe.adapter.GenericAdapterFactory;
import de.pontonconsulting.xmlpipe.adapter.ISpecificAdapter;
import de.pontonconsulting.xmlpipe.adapter.MessageResult;
import de.pontonconsulting.xmlpipe.adapter.as4certificateupdate.AS4CertificateUpdateBackendMessageGenerator;
import de.pontonconsulting.xmlpipe.adapter.as4certificateupdate.AS4CertificateUpdateBackendMessageHandler;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.AgreementNotFoundException;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpa.CommunicationNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.BackEndMessage;
import de.pontonconsulting.xmlpipe.message.BackEndMessageException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public class AS4CertificateUpdateAdapter
implements ISpecificAdapter {
    public static final String ID = "AS4CertificateUpdateAdapter";
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.AS4CertificateUpdateAdapter");
    private static final String MESSENGER_ADDRESS = "localhost";
    private static final String MESSENGER_PATH = "/pontonxp/AdapterService";
    private static final int DEFAULT_PORT = 8080;
    private final Agreements agreements;
    private final Profiles profiles;
    private final GenericAdapter genericAdapter;
    private final AS4CertificateUpdateBackendMessageGenerator as4CertificateUpdateBackendMessageGenerator;
    private final AS4CertificateUpdateBackendMessageHandler as4CertificateUpdateBackendMessageHandler;
    private final File workFolder;

    public AS4CertificateUpdateAdapter(Agreements agreements, Profiles profiles, AS4CertificateUpdateBackendMessageGenerator as4CertificateUpdateBackendMessageGenerator, AS4CertificateUpdateBackendMessageHandler as4CertificateUpdateBackendMessageHandler, GenericAdapterFactory genericAdapterFactory) throws AdapterException, IOException {
        this.agreements = agreements;
        this.profiles = profiles;
        this.as4CertificateUpdateBackendMessageGenerator = as4CertificateUpdateBackendMessageGenerator;
        this.as4CertificateUpdateBackendMessageHandler = as4CertificateUpdateBackendMessageHandler;
        this.workFolder = this.createWorkFolder().toFile();
        this.genericAdapter = this.createGenericAdapter(genericAdapterFactory);
    }

    private Path createWorkFolder() throws IOException {
        Path workFolder = Files.createTempDirectory(Path.of(System.getProperty("java.io.tmpdir"), new String[0]), this.getID(), new FileAttribute[0]).toAbsolutePath();
        LOG.info("Using WorkFolder: {}", (Object)workFolder);
        return workFolder;
    }

    private ExtendedGenericAdapter createGenericAdapter(GenericAdapterFactory genericAdapterFactory) throws AdapterException, IOException {
        ExtendedGenericAdapter genericAdapter = genericAdapterFactory.createExtendedGenericAdapter(this.getID());
        genericAdapter.setEndAdapter((ISpecificAdapter)this);
        genericAdapter.addMessengerConnection(MESSENGER_ADDRESS, 8080, MESSENGER_PATH);
        return genericAdapter;
    }

    public void sendAS4CertificateUpdateRequestMessage(CppPartner localSender, String certId) {
        if (localSender.isLocal()) {
            this.agreements.getAgreementIdsForPartner(localSender.getLocalId()).forEach(agreementId -> {
                try {
                    Agreement agreement = this.agreements.getAgreement((String)agreementId, false);
                    this.sendCertUpdateRequest(localSender, certId, agreement);
                }
                catch (AgreementException e) {
                    LOG.error("Could not load agreement with  id '{}': {}", agreementId, (Object)e.toString());
                }
            });
        }
    }

    private void sendCertUpdateRequest(CppPartner localSender, String certId, Agreement agreement) {
        BackEndMessage backEndMessage = this.as4CertificateUpdateBackendMessageGenerator.generateUpdateRequestMessage(localSender, certId, agreement, this.workFolder);
        LOG.info("sending CertUpdateRequest {}->{}", (Object)agreement.getLocalPartnerId(), (Object)agreement.getRemotePartnerId());
        this.sendBackendMessage(backEndMessage);
    }

    public void sendAS4TestMessage(CppPartner sender, CppPartner receiver, Agreement agreement) {
        BackEndMessage testMessage = this.as4CertificateUpdateBackendMessageGenerator.generateAS4TestMessage(sender, receiver, agreement, this.workFolder);
        LOG.info("sending AS4 test message {}->{}", (Object)agreement.getLocalPartnerId(), (Object)agreement.getRemotePartnerId());
        this.sendBackendMessage(testMessage);
    }

    private void sendBackendMessage(BackEndMessage backEndMessage) {
        if (backEndMessage != null) {
            try {
                MessageResult messageResult = this.genericAdapter.sendMessage(backEndMessage);
                if (!new MessageResult(MessageResult.MSG_SUCCESSFULLY_SEND).equals((Object)messageResult)) {
                    LOG.error("Unable to send {} from sender {} to receiver {} with message result {}", (Object)backEndMessage.getMessageName(), (Object)backEndMessage.getSenderOrganisationText(), (Object)backEndMessage.getReceiverOrganisationText(), (Object)messageResult);
                }
            }
            catch (AdapterException e) {
                LOG.error("Unable to send {} from sender {} to receiver {}", (Object)backEndMessage.getMessageName(), (Object)backEndMessage.getSenderOrganisationText(), (Object)backEndMessage.getReceiverOrganisationText(), (Object)e);
            }
        }
    }

    public boolean verifyTestResultsAndSwitchAgreement(Agreement agreement, CppPartner sender, CppPartner receiver, String as4UpdatedAgreementRef) {
        try {
            return this.as4CertificateUpdateBackendMessageHandler.verifyTestResultsAndSwitchAgreement(agreement, sender, receiver, as4UpdatedAgreementRef);
        }
        catch (AgreementException | ProfileException e) {
            LOG.error("Cannot save agreement with sender {} and receiver {}.", (Object)sender.getLocalId(), (Object)receiver.getLocalId());
            return false;
        }
    }

    public void cleanUpAgreement(Agreement agreement) throws AgreementException, ProfileException {
        LOG.debug("cleanup certificateUpdateRequest in agreement {}->{}", (Object)agreement.getLocalPartnerId(), (Object)agreement.getRemotePartnerId());
        String as4CertUpdateID = agreement.getAS4CertUpdateID();
        String as4CertUpdateInitiatorInternalId = agreement.getAS4CertUpdateInitiator();
        CppPartner as4CertUpdateInitiator = this.profiles.getProfileForInternalId(as4CertUpdateInitiatorInternalId, false);
        if (as4CertUpdateInitiator.isRemote()) {
            as4CertUpdateInitiator.deleteCertificate(as4CertUpdateID);
            this.profiles.partnerCertificateUpdated(as4CertUpdateInitiator);
        }
        this.as4CertificateUpdateBackendMessageHandler.cleanUpAgreement(agreement);
    }

    public MessageResult receiveMessage(BackEndMessage message) {
        LOG.info("[{}] received message {}", (Object)message.getDatabaseId(), (Object)message.getMessageName());
        try {
            CppPartner sender = this.profiles.getProfileForInternalId(message.getSenderOrganisationText(), false);
            CppPartner receiver = this.profiles.getProfileForInternalId(message.getReceiverOrganisationText(), false);
            Agreement agreement = this.agreements.getAgreement(receiver.getLocalId(), sender.getLocalId(), true);
            Communication communication = agreement.getCommunication(sender.getLocalId(), receiver.getLocalId());
            switch (message.getMessageName()) {
                case "CertUpdateRequest": {
                    this.respondToCertUpdateRequest(message, sender, receiver, agreement, communication);
                    return new MessageResult(MessageResult.MSG_SUCCESSFULLY_RECEIVED);
                }
                case "CertUpdateResponse": {
                    this.respondToCertUpdateResponse(message, sender, receiver, agreement);
                    return new MessageResult(MessageResult.MSG_SUCCESSFULLY_RECEIVED);
                }
                case "CertUpdateException": {
                    this.cleanUpAgreement(agreement);
                    return new MessageResult(MessageResult.MSG_SUCCESSFULLY_RECEIVED);
                }
                case "PING": {
                    this.respondToAS4TestMessageRequest(sender, receiver, agreement);
                    return new MessageResult(MessageResult.MSG_SUCCESSFULLY_RECEIVED);
                }
            }
        }
        catch (AgreementNotFoundException | CommunicationNotFoundException | ProfileException e) {
            LOG.error("[{}] Error while receiving message for getting profiles and agreement", (Object)message.getDatabaseId());
        }
        catch (AdapterException e) {
            LOG.error("[{}] Error while sending cert update response", (Object)message.getDatabaseId());
        }
        catch (BackEndMessageException | TransformerException e) {
            LOG.error("[{}] Error while creating backend message", (Object)message.getDatabaseId());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error("[{}] Error while processing message", (Object)message.getDatabaseId());
        }
        catch (AgreementException e) {
            LOG.error("Cannot save agreement.");
        }
        return new MessageResult(MessageResult.ADAPTER_REJECTED_MESSAGE);
    }

    private void respondToAS4TestMessageRequest(CppPartner sender, CppPartner receiver, Agreement agreement) throws AgreementException, ProfileException {
        boolean sendTestMessageResponse = this.as4CertificateUpdateBackendMessageHandler.handleCertTestMessageRequest(sender, receiver, agreement);
        if (sendTestMessageResponse) {
            BackEndMessage backEndMessageTestMessageResponse = this.as4CertificateUpdateBackendMessageGenerator.generateAS4TestMessage(receiver, sender, agreement, this.workFolder);
            this.sendBackendMessage(backEndMessageTestMessageResponse);
        }
    }

    private void respondToCertUpdateResponse(BackEndMessage message, CppPartner sender, CppPartner receiver, Agreement agreement) throws BackEndMessageException, IOException, SAXException, AgreementException, ParserConfigurationException {
        boolean sendTestMessage = this.as4CertificateUpdateBackendMessageHandler.handleCertUpdateResponseMessage(message, agreement);
        if (sendTestMessage) {
            BackEndMessage backEndMessageTestMessage = this.as4CertificateUpdateBackendMessageGenerator.generateAS4TestMessage(receiver, sender, agreement, this.workFolder);
            this.sendBackendMessage(backEndMessageTestMessage);
        }
    }

    private void respondToCertUpdateRequest(BackEndMessage message, CppPartner sender, CppPartner receiver, Agreement agreement, Communication communication) throws BackEndMessageException, TransformerException, SAXException, IOException, AgreementException, AdapterException, ParserConfigurationException {
        BackEndMessage backEndMessage = this.as4CertificateUpdateBackendMessageHandler.handleCertUpdateRequestMessage(message, sender, receiver, agreement, communication, this.workFolder);
        this.profiles.partnerCertificateUpdated(sender);
        this.genericAdapter.sendMessage(backEndMessage);
    }

    public MessageResult receiveAcknowledgement(BackEndMessage message) {
        LOG.info("[{}] received acknowledgement {}", (Object)message.getDatabaseId(), (Object)message.getMessageName());
        if ("Pong".equals(message.getProcessingDirectiveAsString("AckResult"))) {
            try {
                CppPartner sender = this.profiles.getProfileForInternalId(message.getSenderOrganisationText(), false);
                CppPartner receiver = this.profiles.getProfileForInternalId(message.getReceiverOrganisationText(), false);
                Agreement agreement = this.agreements.getAgreement(receiver.getLocalId(), sender.getLocalId(), true);
                this.as4CertificateUpdateBackendMessageHandler.handleCertTestMessageResponse(sender, receiver, agreement);
            }
            catch (AgreementException | ProfileException e) {
                LOG.error("Cannot find profile or agreement.", (Throwable)e);
            }
        }
        return new MessageResult(MessageResult.MSG_SUCCESSFULLY_RECEIVED);
    }

    public MessageResult receiveTestMessage(BackEndMessage message) {
        LOG.debug("[{}] Received test message, handling as normal message", (Object)message.getDatabaseId());
        return this.receiveMessage(message);
    }

    public String getID() {
        return ID;
    }

    public String getStatus() {
        return "AS4CertificateUpdateAdapter is ready.";
    }

    public boolean supportsAcknowledgements() {
        return true;
    }

    public boolean supportsAttachments() {
        return false;
    }

    public int getNumberOfParallelThreads() {
        return 1;
    }

    public File getWorkFolder() {
        return this.workFolder;
    }

    public boolean doSelfCheck() {
        return true;
    }

    public String shutdown() {
        return this.genericAdapter.shutdown().getDescription();
    }
}

