/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter;

import de.pontonconsulting.xmlpipe.adapter.AdapterInfo;
import de.pontonconsulting.xmlpipe.adapter.AdapterRegistry;
import de.pontonconsulting.xmlpipe.adapter.IEventNotifier;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.events.ServiceLevel;
import de.pontonconsulting.xmlpipe.events.ShutdownCompleted;
import de.pontonconsulting.xmlpipe.events.ShutdownService;
import de.pontonconsulting.xmlpipe.events.StartupCompleted;
import de.pontonconsulting.xmlpipe.events.StartupService;
import de.pontonconsulting.xmlpipe.messenger.IServiceProvider;
import de.pontonconsulting.xmlpipe.messenger.adapter.AdapterAccessException;
import de.pontonconsulting.xmlpipe.messenger.adapter.AdapterAccessFactory;
import de.pontonconsulting.xmlpipe.messenger.adapter.IAdapterAccess;
import de.pontonconsulting.xmlpipe.util.PontonThreadFactory;
import jakarta.annotation.PostConstruct;
import java.security.cert.X509Certificate;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class EventNotifier
implements IServiceProvider,
IEventNotifier {
    private final ApplicationEventPublisher applicationEventPublisher;
    private static Log _log = LogFactory.getLog((String)"Messenger.EventNotifier");
    private final AdapterAccessFactory _adapterAccessFactory;
    private final AdapterRegistry _registry;
    private final Profiles _profiles;
    private final Agreements _agreements;
    private final ExecutorService _scheduler = new ThreadPoolExecutor(1, 1, 600L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new PontonThreadFactory("EventNotify"));

    public EventNotifier(ApplicationEventPublisher applicationEventPublisher, AdapterAccessFactory adapterAccessFactory, AdapterRegistry registry, Profiles profiles, Agreements agreements) {
        this.applicationEventPublisher = applicationEventPublisher;
        this._adapterAccessFactory = adapterAccessFactory;
        this._registry = registry;
        this._profiles = profiles;
        this._agreements = agreements;
    }

    public void agreementAdded(String localPartnerId, String remotePartnerId) {
        this._scheduler.submit(new AgreementAddedEvent(localPartnerId, remotePartnerId));
    }

    public void agreementDeleted(String localPartnerId, String remotePartnerId) {
        this._scheduler.submit(new AgreementDeletedEvent(localPartnerId, remotePartnerId));
    }

    public void agreementModified(String localPartnerId, String remotePartnerId) {
        this._scheduler.submit(new AgreementModifiedEvent(localPartnerId, remotePartnerId));
    }

    public void partnerAdded(String partnerId, String displayName, boolean isLocalPartner) {
        this._scheduler.submit(new PartnerAddedEvent(partnerId, displayName, isLocalPartner));
    }

    public void partnerDeleted(String partnerId, String displayName, boolean isLocalPartner) {
        this._scheduler.submit(new PartnerDeletedEvent(partnerId, displayName, isLocalPartner));
    }

    public void partnerModified(String partnerId, String oldPartnerId, String displayName, boolean isLocalPartner) {
        this._scheduler.submit(new PartnerModifiedEvent(partnerId, oldPartnerId, displayName, isLocalPartner));
    }

    public void partnerCertificateAdded(String partnerId, Object certificate, boolean isLocalPartner) {
        this._scheduler.submit(new PartnerCertificateAddedEvent(partnerId, (X509Certificate)certificate, isLocalPartner));
    }

    public void partnerCertificateDeleted(String partnerId, Object certificate, boolean isLocalPartner) {
        this._scheduler.submit(new PartnerCertificateDeletedEvent(partnerId, (X509Certificate)certificate, isLocalPartner));
    }

    @PostConstruct
    public void init() {
        this._profiles.addPartnerEventListener(this);
        this._agreements.addAgreementEventListener(this);
    }

    private void handleException(AdapterInfo adapter, AdapterAccessException e) {
        if (e.getErrorNumber() == 12005) {
            _log.warn((Object)("Adapter: " + adapter.getId() + " is down or has a communication problem. " + e.getMessage()));
        } else {
            _log.warn((Object)("Adapter: " + adapter.getId() + " had a communication problem. Event Notification not delivered: " + e.getMessage()));
        }
    }

    @Override
    public ServiceLevel getServiceLevel() {
        return ServiceLevel.getServiceLevel(this.getClass());
    }

    @Override
    public String getServiceName() {
        return "eventNotifier";
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof StartupService) {
            StartupService startupService = (StartupService)event;
            if (this.getServiceLevel() == startupService.getServiceLevel()) {
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new StartupCompleted(this));
            }
        } else if (event instanceof ShutdownService) {
            ShutdownService shutdownEvent = (ShutdownService)event;
            if (this.getServiceLevel() == shutdownEvent.getServiceLevel()) {
                this._scheduler.shutdownNow();
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new ShutdownCompleted(this));
            }
        }
    }

    private class AgreementAddedEvent
    implements Runnable {
        private String _localPartnerId;
        private String _remotePartnerId;

        private AgreementAddedEvent(String localPartnerId, String remotePartnerId) {
            this._localPartnerId = localPartnerId;
            this._remotePartnerId = remotePartnerId;
        }

        @Override
        public void run() {
            AdapterInfo[] listeners = EventNotifier.this._registry.getAgreementEventListeners();
            for (int i = 0; i < listeners.length; ++i) {
                AdapterInfo adapter = listeners[i];
                IAdapterAccess access = EventNotifier.this._adapterAccessFactory.getAdapterAccess(adapter);
                try {
                    access.agreementAdded(this._localPartnerId, this._remotePartnerId);
                    continue;
                }
                catch (AdapterAccessException e) {
                    EventNotifier.this.handleException(adapter, e);
                    continue;
                }
                catch (Exception e) {
                    _log.warn((Object)("could not send eventnotification to adapter " + adapter.getId() + " : " + String.valueOf(e)));
                }
            }
        }
    }

    private class AgreementDeletedEvent
    implements Runnable {
        private String _localPartnerId;
        private String _remotePartnerId;

        private AgreementDeletedEvent(String localPartnerId, String remotePartnerId) {
            this._localPartnerId = localPartnerId;
            this._remotePartnerId = remotePartnerId;
        }

        @Override
        public void run() {
            AdapterInfo[] listeners = EventNotifier.this._registry.getAgreementEventListeners();
            for (int i = 0; i < listeners.length; ++i) {
                AdapterInfo adapter = listeners[i];
                IAdapterAccess access = EventNotifier.this._adapterAccessFactory.getAdapterAccess(adapter);
                try {
                    access.agreementDeleted(this._localPartnerId, this._remotePartnerId);
                    continue;
                }
                catch (AdapterAccessException e) {
                    EventNotifier.this.handleException(adapter, e);
                    continue;
                }
                catch (Exception e) {
                    _log.warn((Object)("could not send eventnotification to adapter " + adapter.getId() + " : " + String.valueOf(e)));
                }
            }
        }
    }

    private class AgreementModifiedEvent
    implements Runnable {
        private String _localPartnerId;
        private String _remotePartnerId;

        private AgreementModifiedEvent(String localPartnerId, String remotePartnerId) {
            this._localPartnerId = localPartnerId;
            this._remotePartnerId = remotePartnerId;
        }

        @Override
        public void run() {
            AdapterInfo[] listeners = EventNotifier.this._registry.getAgreementEventListeners();
            for (int i = 0; i < listeners.length; ++i) {
                AdapterInfo adapter = listeners[i];
                IAdapterAccess access = EventNotifier.this._adapterAccessFactory.getAdapterAccess(adapter);
                try {
                    access.agreementModified(this._localPartnerId, this._remotePartnerId);
                    continue;
                }
                catch (AdapterAccessException e) {
                    EventNotifier.this.handleException(adapter, e);
                    continue;
                }
                catch (Exception e) {
                    _log.warn((Object)("could not send eventnotification to adapter " + adapter.getId() + " : " + String.valueOf(e)));
                }
            }
        }
    }

    private class PartnerAddedEvent
    implements Runnable {
        private String _partnerId;
        private String _displayName;
        private boolean _isLocalPartner;

        private PartnerAddedEvent(String partnerId, String displayName, boolean isLocalPartner) {
            this._partnerId = partnerId;
            this._displayName = displayName;
            this._isLocalPartner = isLocalPartner;
        }

        @Override
        public void run() {
            AdapterInfo[] listeners = EventNotifier.this._registry.getPartnerEventListeners();
            for (int i = 0; i < listeners.length; ++i) {
                AdapterInfo adapter = listeners[i];
                IAdapterAccess access = EventNotifier.this._adapterAccessFactory.getAdapterAccess(adapter);
                try {
                    access.partnerAdded(this._partnerId, this._displayName, this._isLocalPartner);
                    continue;
                }
                catch (AdapterAccessException e) {
                    EventNotifier.this.handleException(adapter, e);
                    continue;
                }
                catch (Exception e) {
                    _log.warn((Object)("could not send eventnotification to adapter " + adapter.getId() + " : " + String.valueOf(e)));
                }
            }
        }
    }

    private class PartnerDeletedEvent
    implements Runnable {
        private String _partnerId;
        private String _displayName;
        private boolean _isLocalPartner;

        private PartnerDeletedEvent(String partnerId, String displayName, boolean isLocalPartner) {
            this._partnerId = partnerId;
            this._displayName = displayName;
            this._isLocalPartner = isLocalPartner;
        }

        @Override
        public void run() {
            AdapterInfo[] listeners = EventNotifier.this._registry.getPartnerEventListeners();
            for (int i = 0; i < listeners.length; ++i) {
                AdapterInfo adapter = listeners[i];
                IAdapterAccess access = EventNotifier.this._adapterAccessFactory.getAdapterAccess(adapter);
                try {
                    access.partnerDeleted(this._partnerId, this._displayName, this._isLocalPartner);
                    continue;
                }
                catch (AdapterAccessException e) {
                    EventNotifier.this.handleException(adapter, e);
                    continue;
                }
                catch (Exception e) {
                    _log.warn((Object)("could not send eventnotification to adapter " + adapter.getId() + " : " + String.valueOf(e)));
                }
            }
        }
    }

    private class PartnerModifiedEvent
    implements Runnable {
        private String _partnerId;
        private String _oldPartnerId;
        private String _displayName;
        private boolean _isLocalPartner;

        private PartnerModifiedEvent(String partnerId, String oldPartnerId, String displayName, boolean isLocalPartner) {
            this._partnerId = partnerId;
            this._oldPartnerId = oldPartnerId;
            this._displayName = displayName;
            this._isLocalPartner = isLocalPartner;
        }

        @Override
        public void run() {
            AdapterInfo[] listeners = EventNotifier.this._registry.getPartnerEventListeners();
            for (int i = 0; i < listeners.length; ++i) {
                AdapterInfo adapter = listeners[i];
                IAdapterAccess access = EventNotifier.this._adapterAccessFactory.getAdapterAccess(adapter);
                try {
                    access.partnerModifed(this._partnerId, this._oldPartnerId, this._displayName, this._isLocalPartner);
                    continue;
                }
                catch (AdapterAccessException e) {
                    EventNotifier.this.handleException(adapter, e);
                    continue;
                }
                catch (Exception e) {
                    _log.warn((Object)("could not send eventnotification to adapter " + adapter.getId() + " : " + String.valueOf(e)));
                }
            }
        }
    }

    private class PartnerCertificateAddedEvent
    implements Runnable {
        private final String partnerId;
        private final X509Certificate certificate;
        private final boolean isLocalPartner;

        public PartnerCertificateAddedEvent(String partnerId, X509Certificate certificate, boolean isLocalPartner) {
            this.partnerId = partnerId;
            this.certificate = certificate;
            this.isLocalPartner = isLocalPartner;
        }

        @Override
        public void run() {
            AdapterInfo[] listeners = EventNotifier.this._registry.getPartnerCertificateEventListeners();
            for (int i = 0; i < listeners.length; ++i) {
                AdapterInfo adapter = listeners[i];
                IAdapterAccess access = EventNotifier.this._adapterAccessFactory.getAdapterAccess(adapter);
                try {
                    access.partnerCertificateAdded(this.partnerId, this.certificate, this.isLocalPartner);
                    continue;
                }
                catch (AdapterAccessException e) {
                    EventNotifier.this.handleException(adapter, e);
                    continue;
                }
                catch (Exception e) {
                    _log.warn((Object)("could not send eventnotification to adapter " + adapter.getId() + " : " + String.valueOf(e)));
                }
            }
        }
    }

    private class PartnerCertificateDeletedEvent
    implements Runnable {
        private final String partnerId;
        private final X509Certificate certificate;
        private final boolean isLocalPartner;

        public PartnerCertificateDeletedEvent(String partnerId, X509Certificate certificate, boolean isLocalPartner) {
            this.partnerId = partnerId;
            this.certificate = certificate;
            this.isLocalPartner = isLocalPartner;
        }

        @Override
        public void run() {
            AdapterInfo[] listeners = EventNotifier.this._registry.getPartnerCertificateEventListeners();
            for (int i = 0; i < listeners.length; ++i) {
                AdapterInfo adapter = listeners[i];
                IAdapterAccess access = EventNotifier.this._adapterAccessFactory.getAdapterAccess(adapter);
                try {
                    access.partnerCertificateDeleted(this.partnerId, this.certificate, this.isLocalPartner);
                    continue;
                }
                catch (AdapterAccessException e) {
                    EventNotifier.this.handleException(adapter, e);
                    continue;
                }
                catch (Exception e) {
                    _log.warn((Object)("could not send eventnotification to adapter " + adapter.getId() + " : " + String.valueOf(e)));
                }
            }
        }
    }
}

