/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.activation.capability;

import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.xmlpipe.activation.MessengerActivation;
import de.pontonconsulting.xmlpipe.activation.capability.AbstractCapability;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlainCapability
extends AbstractCapability {
    private static final Logger LOGGER = LogManager.getLogger((String)"Messenger.PlainCapability");
    private final AtomicBoolean enabled = new AtomicBoolean(false);

    public PlainCapability(MessengerActivation activationProvider) {
        super(activationProvider);
    }

    @Override
    protected void doCapabilityCheck() {
        try {
            this.enabled.set(this.activationProvider.isPlainMessagingEnabled());
        }
        catch (ActivationException e) {
            LOGGER.error(e.getMessage());
            this.enabled.set(false);
        }
    }

    @Override
    protected boolean isEnabled() {
        return this.enabled.get();
    }

    @Override
    public boolean isSupported(String packageName) {
        return "Plain".equals(packageName);
    }
}

