/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.activation;

import de.pontonconsulting.activation.Activation;
import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.activation.IProductStateChecker;
import de.pontonconsulting.xmlpipe.activation.NetworkCards;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProductStateChecker
implements IProductStateChecker {
    private static final Logger LOGGER = LogManager.getLogger((String)"Messenger.ProductStateChecker");
    public static final String TOTAL_PARTNER_COUNT = "TotalPartnerCount:";
    public static final int LOCAL_PARTNER_LIMIT = 10;
    private final Profiles profiles;
    private final CertificateUtility certificateUtility;
    private final NetworkCards networkCards;

    public ProductStateChecker(Profiles profiles, CertificateUtility certificateUtility, NetworkCards networkCards) {
        this.profiles = profiles;
        this.certificateUtility = certificateUtility;
        this.networkCards = networkCards;
    }

    public void checkProductState(Activation activation) throws ActivationException {
        LOGGER.trace("check product state for {}", (Object)this.certificateUtility.toUsingInfoText(activation.getCertificate()));
        this.checkLocalIP(activation);
        this.checkPartnerWithPartyIDs(activation);
    }

    private void checkLocalIP(Activation activation) throws ActivationException {
        String ip = activation.getCertExtensionFirstValue("1.3.6.1.4.1.14136.1.5");
        String prodLocalIP = this.networkCards.getDefaultInetAddress().getHostAddress();
        if (ip != null) {
            String clusterFlagValue = activation.getCertExtensionFirstValue("1.3.6.1.4.1.14136.1.7");
            if (!ip.equals(prodLocalIP) && StringUtils.isBlank((CharSequence)clusterFlagValue)) {
                throw new ActivationException(2000L, "activation was created for another IP address");
            }
        }
    }

    private void checkPartnerWithPartyIDs(Activation activation) throws ActivationException {
        String[] oidPartyIdArray = activation.getCertExtensionValues("1.3.6.1.4.1.14136.1.4");
        HashMap<String, String[]> activationPartnersMap = new HashMap<String, String[]>();
        for (String partyIdExtension : oidPartyIdArray) {
            String[] partnerWithPartyIDs = activation.getCertExtensionValues(partyIdExtension);
            ArrayList<String> temp = new ArrayList<String>(Arrays.asList(partnerWithPartyIDs));
            String localPartnerName = (String)temp.remove(0);
            activationPartnersMap.put(localPartnerName, temp.toArray(new String[0]));
        }
        Map<String, String[]> localPartnerMap = this.profiles.getLocalPartnerWithPartyIDs();
        Set<String> localPartnerKeys = localPartnerMap.keySet();
        if (localPartnerKeys.size() >= 10) {
            if (activationPartnersMap.get(TOTAL_PARTNER_COUNT + localPartnerMap.size()) == null) {
                throw new ActivationException(2001L, "activation was created for another number of local partners");
            }
        } else {
            Set activationPartnersMapKeys = activationPartnersMap.keySet();
            if (activationPartnersMapKeys.size() != localPartnerKeys.size()) {
                throw new ActivationException(2001L, "activation was created for another number of local partners");
            }
            for (String activationPartnerName : activationPartnersMapKeys) {
                Object[] activationPartyIDs = (String[])activationPartnersMap.get(activationPartnerName);
                Object[] messengerPartyIDs = localPartnerMap.get(activationPartnerName);
                if (activationPartyIDs == null) {
                    throw new ActivationException(2002L, "Party Ids for " + activationPartnerName + " in activation was empty.");
                }
                if (messengerPartyIDs == null) {
                    throw new ActivationException(2002L, "Party Ids for " + activationPartnerName + " in messenger was empty.");
                }
                Arrays.sort(activationPartyIDs);
                Arrays.sort(messengerPartyIDs);
                if (Arrays.equals(activationPartyIDs, messengerPartyIDs)) continue;
                throw new ActivationException(2002L, "activation was created for other partyIDs for one of local partners");
            }
        }
    }
}

