/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.activation;

import de.pontonconsulting.xmlpipe.activation.NetInterface;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkCards {
    private static Logger LOG = LogManager.getLogger((String)"Messenger.NetworkCards");
    private TreeSet<NetInterface> networkInterfaces = new TreeSet();
    private NetInterface defaultNetworkInterface;
    private InetAddress defaultIpAddress;

    public NetworkCards() {
        this.determineAllHardwareNetworkCards();
        this.determineDefaultInetAddress();
        this.determineDefaultInterface();
    }

    private void determineAllHardwareNetworkCards() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (networkInterface.getHardwareAddress() == null || networkInterface.getHardwareAddress().length <= 0 || !networkInterface.getInetAddresses().hasMoreElements()) continue;
                this.networkInterfaces.add(new NetInterface(networkInterface.getHardwareAddress(), networkInterface.getInetAddresses()));
            }
        }
        catch (SocketException e) {
            LOG.warn("could not detect network cards. {}", (Object)e.toString());
        }
    }

    private void determineDefaultInterface() {
        InetAddress defaultIP = this.getDefaultInetAddress();
        Iterator<NetInterface> cards = this.getInterfaces();
        while (cards.hasNext()) {
            NetInterface networkInterface = cards.next();
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            this.defaultNetworkInterface = networkInterface;
            while (addresses.hasMoreElements()) {
                InetAddress inetAddress = addresses.nextElement();
                if (!inetAddress.equals(defaultIP)) continue;
                this.defaultNetworkInterface = networkInterface;
                return;
            }
        }
    }

    protected void determineDefaultInetAddress() {
        try (DatagramSocket socket = new DatagramSocket();){
            socket.connect(InetAddress.getByName("83.169.3.162"), 10002);
            this.defaultIpAddress = socket.getLocalAddress();
            if (this.defaultIpAddress == null || this.defaultIpAddress.getHostAddress().contains("0.0.0.0")) {
                this.defaultIpAddress = InetAddress.getLocalHost();
            }
            LOG.debug("local IP is {}", (Object)this.defaultIpAddress);
        }
        catch (SocketException | UnknownHostException e) {
            LOG.warn("could not determine local IP. using loopbackAddress as fallback. {}", (Object)e.toString());
            this.defaultIpAddress = InetAddress.getLoopbackAddress();
        }
    }

    public Iterator<NetInterface> getInterfaces() {
        return this.networkInterfaces.iterator();
    }

    public NetInterface getDefaultInterface() {
        return this.defaultNetworkInterface;
    }

    public InetAddress getDefaultInetAddress() {
        return this.defaultIpAddress;
    }
}

