/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.activation;

import java.math.BigInteger;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;

public class NetInterface
implements Comparable<NetInterface> {
    private byte[] hardwareAddress;
    private ArrayList<InetAddress> inetAddresses;

    public NetInterface(byte[] hardwareAddress, Enumeration<InetAddress> inetAddresses) {
        Objects.requireNonNull(hardwareAddress, "hardwareAddress must not be NULL");
        Objects.requireNonNull(inetAddresses, "inetAddresses must not be null");
        this.hardwareAddress = hardwareAddress;
        this.inetAddresses = Collections.list(inetAddresses);
    }

    public byte[] getHardwareAddress() {
        return this.hardwareAddress;
    }

    public Enumeration<InetAddress> getInetAddresses() {
        return Collections.enumeration(this.inetAddresses);
    }

    @Override
    public int compareTo(NetInterface o) {
        BigInteger n1 = new BigInteger(o.getHardwareAddress());
        BigInteger n2 = new BigInteger(this.getHardwareAddress());
        return n1.compareTo(n2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetInterface that = (NetInterface)o;
        return Arrays.equals(this.hardwareAddress, that.hardwareAddress) && this.inetAddresses.equals(that.inetAddresses);
    }

    public int hashCode() {
        int result = Objects.hash(this.inetAddresses);
        result = 31 * result + Arrays.hashCode(this.hardwareAddress);
        return result;
    }
}

