/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.activation;

import de.pontonconsulting.activation.Activation;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public class GracePeriodCalculator {
    private final ReferenceDateTask referenceDateTask;

    public GracePeriodCalculator(ReferenceDateTask referenceDateTask) {
        this.referenceDateTask = referenceDateTask;
    }

    public long calculateGracePeriod(Activation activation) {
        OffsetDateTime now = this.referenceDateTask.getReferenceOffsetDateTime();
        X509Certificate certificate = activation.getCertificate();
        if (certificate == null) {
            return -1L;
        }
        int reactivationInterval = activation.getReactivationInterval();
        Date notBefore = certificate.getNotBefore();
        OffsetDateTime reactivationDate = notBefore.toInstant().atOffset(ZoneOffset.UTC).plusMonths(reactivationInterval);
        if (now.isAfter(reactivationDate)) {
            OffsetDateTime endActivationDate = reactivationDate.plusMonths(reactivationInterval);
            return ChronoUnit.DAYS.between(now.withHour(0).withMinute(0).withSecond(0).withNano(0), endActivationDate.withHour(0).withMinute(0).withSecond(0).withNano(0));
        }
        return -1L;
    }
}

