/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.activation;

import de.pontonconsulting.activation.Activation;
import de.pontonconsulting.activation.ActivationException;
import de.pontonconsulting.activation.ActivationRequest;
import de.pontonconsulting.activation.IActivationManager;
import de.pontonconsulting.activation.IProductStateChecker;
import de.pontonconsulting.activation.IRequestExtensionBuilder;
import de.pontonconsulting.activation.License;
import de.pontonconsulting.xmlpipe.activation.MessengerActivation;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.config.SystemEvent;
import de.pontonconsulting.xmlpipe.events.activation.ActivationInstalledEvent;
import de.pontonconsulting.xmlpipe.events.activation.LicenseInstalledEvent;
import de.pontonconsulting.xmlpipe.events.activation.ValidateActivationEvent;
import de.pontonconsulting.xmlpipe.events.activation.ValidateLicenseEvent;
import de.pontonconsulting.xmlpipe.messenger.IMaintenanceChangeListener;
import de.pontonconsulting.xmlpipe.messenger.MaintenanceManager;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.emailnotification.SystemEventNotifier;
import de.pontonconsulting.xmlpipe.messenger.transport.TransportException;
import de.pontonconsulting.xmlpipe.messenger.transport.XpHttpClientManager;
import de.pontonconsulting.xmlpipe.util.PontonThreadFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.PrivateKey;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class ActivationControl
implements IMaintenanceChangeListener,
ApplicationListener<ApplicationEvent> {
    static String BEAN_NAME = "activationControl";
    private static final String DEFAULT_ACTIVATION_HTTP = "https://xpactivation.ponton.de/webactivation/HttpListener";
    private static final String PROPERTY_ACTIVATION_HTTP = "ponton.messenger.activation.http";
    private final Logger log = LogManager.getLogger((String)("Messenger." + String.valueOf(this.getClass())));
    private boolean _isActive;
    private final IActivationManager _activationManager;
    private final XpHttpClientManager xpHttpClientManager;
    private final MaintenanceManager _maintenanceManager;
    private final ExecutorService _executor;
    private final Lock _activationLock;
    private final MessengerActivation activationProvider;
    private final IRequestExtensionBuilder requestExtensionBuilder;
    private final IProductStateChecker productStateChecker;
    private final IMessengerProperties messengerProperties;
    private final AtomicBoolean checkForLicenseUpdates = new AtomicBoolean(true);
    private final SystemEventNotifier systemEventNotifier;
    private final ReferenceDateTask referenceDateTask;

    public ActivationControl(IActivationManager activationManager, XpHttpClientManager xpHttpClientManager, MaintenanceManager maintenanceManager, MessengerActivation activationProvider, IRequestExtensionBuilder requestExtensionBuilder, IProductStateChecker productStateChecker, IMessengerProperties messengerProperties, SystemEventNotifier systemEventNotifier, ReferenceDateTask referenceDateTask) {
        this._activationManager = activationManager;
        this.xpHttpClientManager = xpHttpClientManager;
        this._maintenanceManager = maintenanceManager;
        this.activationProvider = activationProvider;
        this.requestExtensionBuilder = requestExtensionBuilder;
        this.productStateChecker = productStateChecker;
        this.messengerProperties = messengerProperties;
        this.systemEventNotifier = systemEventNotifier;
        this.referenceDateTask = referenceDateTask;
        this._maintenanceManager.addMaintenanceChangeListener(this);
        this._activationLock = new ReentrantLock();
        this._executor = Executors.newSingleThreadExecutor(new PontonThreadFactory("ActivationControl_ExecutorService"));
    }

    public void stop() {
        this._executor.shutdownNow();
    }

    public String getActivationServerURI() {
        return this.messengerProperties.getProperty(PROPERTY_ACTIVATION_HTTP, DEFAULT_ACTIVATION_HTTP);
    }

    private void downloadAndInstallNewActivation() {
        String activationServerURI = this.getActivationServerURI();
        try {
            ActivationRequest activationRequest = this._activationManager.generateActivationRequest(this.requestExtensionBuilder);
            String requestAsASCII = activationRequest.getBase64Encoded();
            HttpClient trustAllHttpClient = this.xpHttpClientManager.createXpTrustAllHttpClient();
            URI uri = new URI(activationServerURI);
            this.log.trace("Activation server URI: {}", (Object)uri);
            HttpRequest.Builder builder = HttpRequest.newBuilder(uri);
            HttpRequest request = builder.POST(HttpRequest.BodyPublishers.ofString(requestAsASCII)).build();
            HttpResponse<String> httpResponse = trustAllHttpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (httpResponse.statusCode() / 100 != 2) {
                String error = httpResponse.body();
                this.log.error("Could not download activation: {}", (Object)error);
                throw new TransportException(25003, "HTTP(S) transmission failed. Transmission aborted.");
            }
            PrivateKey key = this._activationManager.getProductIdentification().getPrivateKey();
            String activationBase64 = httpResponse.body();
            Activation newActivation = new Activation(activationBase64, key);
            this._activationManager.importActivation(this.productStateChecker, newActivation);
            this.log.trace("check product state.");
            this._activationManager.checkProductState();
            this.setActive(true);
            this.log.info("A new activation was successfully installed.");
        }
        catch (TransportException | IOException e) {
            this.systemEventNotifier.sendNotification(SystemEvent.ACTIVATION_SERVER_UNREACHABLE, String.format("Could not download activation from %s: %s", activationServerURI, e.getMessage()));
            this.log.error("Problem while contacting activation server: {}. {}", (Object)activationServerURI, (Object)e.getMessage());
        }
        catch (URISyntaxException e) {
            this.log.error("Activation server URI is invalid: {}. {}", (Object)activationServerURI, (Object)e.getMessage());
        }
        catch (ActivationException e) {
            this.log.error("could not import activation. {}", (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public void updateActivationState() {
        this.updateActivationState(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateActivationState(boolean forceActivation) {
        if (this._maintenanceManager.isStarted() && this._activationLock.tryLock()) {
            this.log.debug("Updating activation state.");
            try {
                block15: {
                    try {
                        this.log.trace("check product state.");
                        this._activationManager.checkProductState();
                        this.setActive(true);
                    }
                    catch (ActivationException e) {
                        this.log.error("Error occurred while checking the product state: {}", (Object)e.getMessage());
                        this.setActive(false);
                        if (!this.activationProvider.getLicense().isFullVersion()) break block15;
                        this.log.info("Initiating automatic activation.");
                        this.startAsyncActivationDownload();
                        this._activationLock.unlock();
                        return;
                    }
                }
                long daysLeft = this.activationProvider.getDaysLeft();
                long reactivationInterval = this.activationProvider.getReactivationInterval();
                Activation activation = this.activationProvider.getActivation();
                if (activation != null && activation.getCertificate() != null && reactivationInterval > 0L) {
                    this.log.debug("Reactivation interval is {}", (Object)reactivationInterval);
                    OffsetDateTime now = this.referenceDateTask.getReferenceOffsetDateTime();
                    Date notBefore = activation.getCertificate().getNotBefore();
                    OffsetDateTime endActivationDate = notBefore.toInstant().atOffset(ZoneOffset.UTC).plusMonths(reactivationInterval);
                    OffsetDateTime endActivationDeleteDate = endActivationDate.plusMonths(reactivationInterval);
                    if (this.checkForLicenseUpdates.get() && this.activationProvider.getLicense().isFullVersion()) {
                        if (forceActivation || daysLeft <= 14L || now.isAfter(endActivationDate)) {
                            this.log.debug("Activation will expire in {}. Trying to refresh activation.", (Object)daysLeft);
                            this.startAsyncActivationDownload();
                            if (now.isAfter(endActivationDeleteDate)) {
                                this.log.warn("Activation delete date is {}. Delete activation.", (Object)endActivationDeleteDate);
                                this._activationManager.deleteActivation();
                            }
                        }
                        this.checkForLicenseUpdates.set(false);
                    }
                } else if (this.checkForLicenseUpdates.get() && this.activationProvider.getLicense().isFullVersion() && (daysLeft <= 14L || forceActivation)) {
                    this.log.debug("Activation will expire in {}. Trying to refresh activation.", (Object)daysLeft);
                    this.startAsyncActivationDownload();
                    this.checkForLicenseUpdates.set(false);
                }
            }
            catch (ActivationException e) {
                this.log.error("could not read license. Messenger is not activated: {}", (Object)e.getMessage());
                this.setActive(false);
            }
            finally {
                this._activationLock.unlock();
            }
        }
    }

    private void startAsyncActivationDownload() {
        Future<?> future = this._executor.submit(this::downloadAndInstallNewActivation);
        try {
            future.get(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException | TimeoutException exception) {
            // empty catch block
        }
    }

    public void enableCheckForLicenseUpdates() {
        this.checkForLicenseUpdates.set(true);
    }

    @Override
    public void onMaintenanceChange(MaintenanceManager maintenanceManager) {
        this.updateActivationState();
    }

    public boolean isActive() {
        return this._isActive;
    }

    private void setActive(boolean isActive) {
        this._isActive = isActive;
    }

    public boolean isLicensed() {
        try {
            License license = this.activationProvider.getLicense();
            return license.isFullVersion();
        }
        catch (ActivationException activationException) {
            return false;
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ValidateLicenseEvent || event instanceof ActivationInstalledEvent) {
            this.updateActivationState();
        }
        if (event instanceof LicenseInstalledEvent) {
            this.enableCheckForLicenseUpdates();
            this.updateActivationState();
        }
        if (event instanceof ValidateActivationEvent) {
            this.enableCheckForLicenseUpdates();
            this.updateActivationState(((ValidateActivationEvent)event).isForceActivation());
        }
    }
}

