/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Constants {
    public static final String XP_VENDOR = "PONTON GmbH";
    public static final String XP_NAME = "X/P Messenger";
    public static final String XP_ROLE_ADMINISTRATOR = "ROLE_administrator";
    public static final String XP_ROLE_CONFIG_ADMINISTRATOR = "ROLE_config_administrator";
    public static final String EMPTY = "";
    public static final String NONE = "NONE";
    public static final String XP_ROLE_HTTP_ADAPTER = "ROLE_httpadapter";
    public static final String XP_ROLE_HTTP_ADAPTER_CONFIG = "ROLE_httpadapter_config";
    public static final String XP_ROLE_OPERATOR = "ROLE_operator";
    public static final String XP_ROLE_EXPERT = "ROLE_expert";
    public static final String XP_ROLE_SETUP2FA = "ROLE_setup2fa";
    public static final String PONTONXP_HOME_PATH = "$PONTONXP_HOME";
    public static final String XP_CONFIG_PATH = "$XP_CONFIG_FOLDER";
    public static final String CLUSTER_HOME_PATH = "$CLUSTER_HOME";
    public static final String CONTEXT_PATH = "$CONTEXT";
    private static long _buildNumber = Long.MIN_VALUE;
    private static final Pattern NON_DIGIT_PATTERN = Pattern.compile("\\D*");
    private static String _build;
    private static String _buildDate;
    private static String _edition;
    private static String _httpXpName;
    public static final String[][] ISO_COUNTRIES;

    public static String getXP_VERSION() {
        return _build;
    }

    public static long getBuildNumber() {
        return _buildNumber;
    }

    public static String getXP_VENDOR() {
        return XP_VENDOR;
    }

    public static String getXP_NAME() {
        return XP_NAME;
    }

    public static String getHTTP_XP_NAME() {
        return _httpXpName;
    }

    public static String[][] getISO_COUNTRIES() {
        return ISO_COUNTRIES;
    }

    public static String getBuildDate() {
        return _buildDate;
    }

    public static String getEdition() {
        return _edition;
    }

    static {
        try {
            ResourceBundle resource = ResourceBundle.getBundle("ponton-messenger-version");
            String versionString = resource.getString("ponton.version").trim();
            String buildString = resource.getString("ponton.buildnumber").trim();
            Matcher m = NON_DIGIT_PATTERN.matcher(buildString);
            buildString = m.replaceAll(EMPTY);
            if (buildString.isEmpty()) {
                buildString = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            }
            _buildNumber = Long.parseLong(buildString);
            _build = versionString + " (Build " + buildString + ")";
            _buildDate = resource.getString("ponton.builddate").trim();
            _edition = resource.getString("ponton.edition").trim();
            _httpXpName = "PontonXP/" + versionString;
        }
        catch (Exception e) {
            _build = "3.2.unversioned Build";
            _buildNumber = -1L;
            _buildDate = "undefined";
            _edition = "papiNet";
            _httpXpName = "PontonXP/undefined";
        }
        ISO_COUNTRIES = new String[][]{{"Afghanistan", "AF"}, {"ALA Aland Islands", "AX"}, {"Albania", "AL"}, {"Algeria", "DZ"}, {"American Samoa", "AS"}, {"Andorra", "AD"}, {"Angola", "AO"}, {"Anguilla", "AI"}, {"Antarctica", "AQ"}, {"Antigua and Barbuda", "AG"}, {"Argentina", "AR"}, {"Armenia", "AM"}, {"Aruba", "AW"}, {"Australia", "AU"}, {"Austria", "AT"}, {"Azerbaijan", "AZ"}, {"Bahamas", "BS"}, {"Bahrain", "BH"}, {"Bangladesh", "BD"}, {"Barbados", "BB"}, {"Belarus", "BY"}, {"Belgium", "BE"}, {"Belize", "BZ"}, {"Benin", "BJ"}, {"Bermuda", "BM"}, {"Bhutan", "BT"}, {"Bolivia", "BO"}, {"Bosnia and Herzegovina", "BA"}, {"Botswana", "BW"}, {"Bouvet Island", "BV"}, {"Brazil", "BR"}, {"British Virgin Islands", "VG"}, {"British Indian Ocean Territory", "IO"}, {"Brunei Darussalam", "BN"}, {"Bulgaria", "BG"}, {"Burkina Faso", "BF"}, {"Burundi", "BI"}, {"Cambodia", "KH"}, {"Cameroon", "CM"}, {"Canada", "CA"}, {"Cape Verde", "CV"}, {"Cayman Islands", "KY"}, {"Central African Republic", "CF"}, {"Chad", "TD"}, {"Chile", "CL"}, {"China", "CN"}, {"Hong Kong, SAR China", "HK"}, {"Macao, SAR China", "MO"}, {"Christmas Island", "CX"}, {"Cocos (Keeling) Islands", "CC"}, {"Colombia", "CO"}, {"Comoros", "KM"}, {"Congo (Brazzaville)", "CG"}, {"Congo, (Kinshasa)", "CD"}, {"Cook Islands", "CK"}, {"Costa Rica", "CR"}, {"Cote dIvoire", "CI"}, {"Croatia", "HR"}, {"Cuba", "CU"}, {"Cyprus", "CY"}, {"Czech Republic", "CZ"}, {"Denmark", "DK"}, {"Djibouti", "DJ"}, {"Dominica", "DM"}, {"Dominican Republic", "DO"}, {"Ecuador", "EC"}, {"Egypt", "EG"}, {"El Salvador", "SV"}, {"Equatorial Guinea", "GQ"}, {"Eritrea", "ER"}, {"Estonia", "EE"}, {"Ethiopia", "ET"}, {"Falkland Islands (Malvinas)", "FK"}, {"Faroe Islands", "FO"}, {"Fiji", "FJ"}, {"Finland", "FI"}, {"France", "FR"}, {"French Guiana", "GF"}, {"French Polynesia", "PF"}, {"French Southern Territories", "TF"}, {"Gabon", "GA"}, {"Gambia", "GM"}, {"Georgia", "GE"}, {"Germany", "DE"}, {"Ghana", "GH"}, {"Gibraltar", "GI"}, {"Greece", "GR"}, {"Greenland", "GL"}, {"Grenada", "GD"}, {"Guadeloupe", "GP"}, {"Guam", "GU"}, {"Guatemala", "GT"}, {"Guernsey", "GG"}, {"Guinea", "GN"}, {"Guinea-Bissau", "GW"}, {"Guyana", "GY"}, {"Haiti", "HT"}, {"Heard and Mcdonald Islands", "HM"}, {"Holy See (Vatican City State)", "VA"}, {"Honduras", "HN"}, {"Hungary", "HU"}, {"Iceland", "IS"}, {"India", "IN"}, {"Indonesia", "ID"}, {"Iran, Islamic Republic of", "IR"}, {"Iraq", "IQ"}, {"Ireland", "IE"}, {"Isle of Man", "IM"}, {"Israel", "IL"}, {"Italy", "IT"}, {"Jamaica", "JM"}, {"Japan", "JP"}, {"Jersey", "JE"}, {"Jordan", "JO"}, {"Kazakhstan", "KZ"}, {"Kenya", "KE"}, {"Kiribati", "KI"}, {"Korea (North)", "KP"}, {"Korea (South)", "KR"}, {"Kuwait", "KW"}, {"Kyrgyzstan", "KG"}, {"Lao PDR", "LA"}, {"Latvia", "LV"}, {"Lebanon", "LB"}, {"Lesotho", "LS"}, {"Liberia", "LR"}, {"Libya", "LY"}, {"Liechtenstein", "LI"}, {"Lithuania", "LT"}, {"Luxembourg", "LU"}, {"Macedonia, Republic of", "MK"}, {"Madagascar", "MG"}, {"Malawi", "MW"}, {"Malaysia", "MY"}, {"Maldives", "MV"}, {"Mali", "ML"}, {"Malta", "MT"}, {"Marshall Islands", "MH"}, {"Martinique", "MQ"}, {"Mauritania", "MR"}, {"Mauritius", "MU"}, {"Mayotte", "YT"}, {"Mexico", "MX"}, {"Micronesia, Federated States of", "FM"}, {"Moldova", "MD"}, {"Monaco", "MC"}, {"Mongolia", "MN"}, {"Montenegro", "ME"}, {"Montserrat", "MS"}, {"Morocco", "MA"}, {"Mozambique", "MZ"}, {"Myanmar", "MM"}, {"Namibia", "NA"}, {"Nauru", "NR"}, {"Nepal", "NP"}, {"Netherlands", "NL"}, {"Netherlands Antilles", "AN"}, {"New Caledonia", "NC"}, {"New Zealand", "NZ"}, {"Nicaragua", "NI"}, {"Niger", "NE"}, {"Nigeria", "NG"}, {"Niue", "NU"}, {"Norfolk Island", "NF"}, {"Northern Mariana Islands", "MP"}, {"Norway", "NO"}, {"Oman", "OM"}, {"Pakistan", "PK"}, {"Palau", "PW"}, {"Palestinian Territory", "PS"}, {"Panama", "PA"}, {"Papua New Guinea", "PG"}, {"Paraguay", "PY"}, {"Peru", "PE"}, {"Philippines", "PH"}, {"Pitcairn", "PN"}, {"Poland", "PL"}, {"Portugal", "PT"}, {"Puerto Rico", "PR"}, {"Qatar", "QA"}, {"Reunion", "RE"}, {"Romania", "RO"}, {"Russian Federation", "RU"}, {"Rwanda", "RW"}, {"Saint-Barthelemy", "BL"}, {"Saint Helena", "SH"}, {"Saint Kitts and Nevis", "KN"}, {"Saint Lucia", "LC"}, {"Saint-Martin (French part)", "MF"}, {"Saint Pierre and Miquelon", "PM"}, {"Saint Vincent and Grenadines", "VC"}, {"Samoa", "WS"}, {"San Marino", "SM"}, {"Sao Tome and Principe", "ST"}, {"Saudi Arabia", "SA"}, {"Senegal", "SN"}, {"Serbia", "RS"}, {"Seychelles", "SC"}, {"Sierra Leone", "SL"}, {"Singapore", "SG"}, {"Slovakia", "SK"}, {"Slovenia", "SI"}, {"Solomon Islands", "SB"}, {"Somalia", "SO"}, {"South Africa", "ZA"}, {"South Georgia and the South Sandwich Islands", "GS"}, {"South Sudan", "SS"}, {"Spain", "ES"}, {"Sri Lanka", "LK"}, {"Sudan", "SD"}, {"Suriname", "SR"}, {"Svalbard and Jan Mayen Islands", "SJ"}, {"Swaziland", "SZ"}, {"Sweden", "SE"}, {"Switzerland", "CH"}, {"Syrian Arab Republic (Syria)", "SY"}, {"Taiwan (Republic of China)", "TW"}, {"Tajikistan", "TJ"}, {"Tanzania, United Republic of", "TZ"}, {"Thailand", "TH"}, {"Timor-Leste", "TL"}, {"Togo", "TG"}, {"Tokelau", "TK"}, {"Tonga", "TO"}, {"Trinidad and Tobago", "TT"}, {"Tunisia", "TN"}, {"Turkey", "TR"}, {"Turkmenistan", "TM"}, {"Turks and Caicos Islands", "TC"}, {"Tuvalu", "TV"}, {"Uganda", "UG"}, {"Ukraine", "UA"}, {"United Arab Emirates", "AE"}, {"United Kingdom", "GB"}, {"United States of America", "US"}, {"US Minor Outlying Islands", "UM"}, {"Uruguay", "UY"}, {"Uzbekistan", "UZ"}, {"Vanuatu", "VU"}, {"Venezuela (Bolivarian Republic)", "VE"}, {"Viet Nam", "VN"}, {"Virgin Islands (US)", "VI"}, {"Wallis and Futuna Islands", "WF"}, {"Western Sahara", "EH"}, {"Yemen", "YE"}, {"Zambia", "ZM"}, {"Zimbabwe", "ZW"}};
    }
}

