/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.common.security;

import de.pontonconsulting.common.security.IPasswordCrypt;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class PasswordCrypt
implements IPasswordCrypt {
    private static final String BOUNCY_CASTLE = "BC";
    private static final String CRYPT_ALGO = "AES/ECB/NoPadding";
    private static final String KEY_ALGO = "AES";
    private static final Charset CHAR_ENCODING = StandardCharsets.UTF_8;
    private Cipher _cipher;
    private SecretKey _key;
    private Random _random;
    private static final byte[] _master = new byte[]{1, -90, -86, -13, -40, -29, -109, 52, 58, 81, -2, -32, 33, 85, 124, 103};

    public PasswordCrypt(String encryptionType) throws UnsupportedEncodingException, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        byte[] adr = null;
        byte[] salt = new byte[8];
        this._random = new Random();
        this._random.nextBytes(salt);
        "".getBytes(CHAR_ENCODING);
        this._cipher = Cipher.getInstance(CRYPT_ALGO, BOUNCY_CASTLE);
        adr = "0.0.0.0".getBytes();
        if ("IpDependent".equals(encryptionType)) {
            try {
                adr = InetAddress.getLocalHost().getAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        System.arraycopy(adr, 0, _master, 6, 4);
        this._key = new SecretKeySpec(_master, KEY_ALGO);
    }

    @Override
    public String decryptPassword(byte[] crypted) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        String resultText = null;
        if (crypted != null) {
            byte[] result = null;
            result = this.doCipher(2, this._key, crypted);
            int keyLength = result[1] & 0xFF;
            if (keyLength + 1 > result.length) {
                throw new InvalidKeyException("Decryption Password incorrect (maybe System IP changed)");
            }
            resultText = new String(result, 2, keyLength, CHAR_ENCODING);
        }
        return resultText;
    }

    @Override
    public byte[] encryptPassword(String password) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        byte[] encodedText = null;
        encodedText = password.getBytes(CHAR_ENCODING);
        int encodedLength = encodedText.length;
        int neededLength = ((encodedLength + 3) / 32 + 1) * 32;
        byte[] plain = new byte[neededLength];
        this._random.nextBytes(plain);
        plain[1] = (byte)encodedLength;
        System.arraycopy(encodedText, 0, plain, 2, encodedText.length);
        return this.doCipher(1, this._key, plain);
    }

    private synchronized byte[] doCipher(int mode, SecretKey key, byte[] input) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        this._cipher.init(mode, key);
        return this._cipher.doFinal(input);
    }
}

