/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.common.net.ntp;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class NtpHeader {
    public static final byte[] defaultHeaderData = new byte[]{27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final NtpHeader defaultHeader = new NtpHeader(defaultHeaderData);
    private byte[] data;
    private static final byte RI_IP_ADDRESS = 0;
    private static final byte RI_CODE = 1;
    private static final byte RI_OTHER = 2;

    private int mp(byte b) {
        int bb = b;
        return bb < 0 ? 256 + bb : bb;
    }

    public NtpHeader(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getLeapYearIndicator() {
        return (this.data[0] & 0xC0) >>> 6;
    }

    public int getVersionNumber() {
        return (this.data[0] & 0x38) >>> 3;
    }

    public int getMode() {
        return this.data[0] & 7;
    }

    public int getStratum() {
        return this.data[1];
    }

    public int getPollInterval() {
        return (int)Math.round(Math.pow(2.0, this.data[2]));
    }

    public double getPrecision() {
        return 1000.0 * Math.pow(2.0, this.data[3]);
    }

    public double getRootDelay() {
        int temp = 0;
        temp = 256 * (256 * (256 * this.data[4] + this.data[5]) + this.data[6]) + this.data[7];
        return 1000.0 * ((double)temp / 65536.0);
    }

    public double getRootDispersion() {
        long temp = 0L;
        temp = 256 * (256 * (256 * this.data[8] + this.data[9]) + this.data[10]) + this.data[11];
        return 1000.0 * ((double)temp / 65536.0);
    }

    private int getReferenceIdentifierType() {
        if (this.getMode() == 3) {
            return 2;
        }
        if (this.getStratum() < 2) {
            return 1;
        }
        if (this.getVersionNumber() <= 3) {
            return 0;
        }
        return 2;
    }

    private InetAddress getReferenceAddress() throws IllegalArgumentException, UnknownHostException {
        if (this.getReferenceIdentifierType() != 0) {
            throw new IllegalArgumentException();
        }
        String temp = this.mp(this.data[12]) + "." + this.mp(this.data[13]) + "." + this.mp(this.data[14]) + "." + this.mp(this.data[15]);
        return InetAddress.getByName(temp);
    }

    private String getReferenceCode() throws IllegalArgumentException {
        if (this.getReferenceIdentifierType() != 1) {
            throw new IllegalArgumentException();
        }
        int codeLength = 0;
        int index = 12;
        boolean zeroFound = false;
        while (!zeroFound && index <= 15) {
            if (this.data[index] == 0) {
                zeroFound = true;
                continue;
            }
            ++index;
            ++codeLength;
        }
        return new String(this.data, 12, codeLength);
    }

    private byte[] getReferenceData() {
        byte[] temp = new byte[]{this.data[12], this.data[13], this.data[14], this.data[15]};
        return temp;
    }

    public Object getReferenceIdentifier() {
        if (this.getReferenceIdentifierType() == 0) {
            try {
                return this.getReferenceAddress();
            }
            catch (Exception e) {
                return this.getReferenceData();
            }
        }
        if (this.getReferenceIdentifierType() == 1) {
            return this.getReferenceCode();
        }
        return this.getReferenceData();
    }

    public String toString() {
        String s = "Leap year indicator : " + this.getLeapYearIndicator() + "\nVersion number : " + this.getVersionNumber() + "\nMode : " + this.getMode() + "\nStratum : " + this.getStratum() + "\nPoll interval : " + this.getPollInterval() + " s\nPrecision : " + this.getPrecision() + " ms\nRoot delay : " + this.getRootDelay() + " ms\nRoot dispersion : " + this.getRootDispersion() + " ms\n";
        Object o = this.getReferenceIdentifier();
        if (o instanceof InetAddress) {
            s = s + "Reference address : " + String.valueOf(o);
        } else if (o instanceof String) {
            s = s + "Reference code : " + String.valueOf(o);
        } else {
            byte[] temp = (byte[])o;
            s = s + "Reference data : " + temp[0] + " " + temp[1] + " " + temp[2] + " " + temp[3];
        }
        return s;
    }
}

