/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.common.net.ntp;

import de.pontonconsulting.common.net.ntp.NtpClientException;
import de.pontonconsulting.common.net.ntp.NtpDatagramPacket;
import de.pontonconsulting.common.net.ntp.NtpInfo;
import de.pontonconsulting.common.net.ntp.TimeStamp;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Date;

public class NtpClient {
    private static final int DEFAULT_NTP_PORT = 123;
    private static final int TIMEOUT = 15000;
    private static final int MAX_HOPS = 15;
    private InetAddress _ntpServer;
    private int _ntpPort;
    private DatagramSocket _socket;
    private int _timeout;

    public NtpClient(InetAddress ntpServer) throws NtpClientException {
        this(ntpServer, 123);
    }

    public NtpClient(InetAddress ntpServer, int ntpPort) throws NtpClientException {
        this._ntpServer = ntpServer;
        this._ntpPort = ntpPort;
        this._timeout = 15000;
        try {
            this._socket = new DatagramSocket();
            this._socket.setSoTimeout(this._timeout);
        }
        catch (SocketException se) {
            throw new NtpClientException("Unable to create the DatagramSocket: " + se.toString());
        }
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setTimeout(int timeout) throws SocketException {
        this._timeout = timeout;
        this._socket.setSoTimeout(timeout);
    }

    private void send(NtpDatagramPacket ntpDatagramPacket) throws IOException {
        this._socket.send(ntpDatagramPacket.getDatagramPacket());
    }

    private void receive(NtpDatagramPacket ntpDatagramPacket) throws IOException {
        this._socket.receive(ntpDatagramPacket.getDatagramPacket());
        ntpDatagramPacket.setReceptionTimeStamp(new TimeStamp(new Date()));
    }

    public NtpInfo getInfo() throws IOException {
        NtpDatagramPacket dpSend = new NtpDatagramPacket(this._ntpServer, this._ntpPort);
        NtpDatagramPacket dpReceive = new NtpDatagramPacket();
        this.send(dpSend);
        this.receive(dpReceive);
        return dpReceive.getInfo();
    }

    public ArrayList<NtpInfo> getTrace() {
        ArrayList<NtpInfo> traceList = new ArrayList<NtpInfo>();
        int hops = 0;
        boolean finished = false;
        NtpClient currentNtpConnection = this;
        while (!finished && hops < 15) {
            try {
                NtpInfo info = currentNtpConnection.getInfo();
                if (currentNtpConnection != this) {
                    currentNtpConnection.close();
                }
                traceList.add(info);
                if (info.referenceIdentifier instanceof InetAddress) {
                    currentNtpConnection = new NtpClient((InetAddress)info.referenceIdentifier);
                    ++hops;
                    continue;
                }
                finished = true;
            }
            catch (Exception e) {
                finished = true;
            }
        }
        return traceList;
    }

    public Date getTime() throws NtpClientException {
        try {
            long offset = this.getInfo().offset;
            return new Date(System.currentTimeMillis() + offset);
        }
        catch (IOException ioe) {
            throw new NtpClientException(ioe.toString());
        }
    }

    public long getOffset() throws NtpClientException {
        try {
            return this.getInfo().offset;
        }
        catch (IOException ioe) {
            throw new NtpClientException(ioe.toString());
        }
    }

    public void close() {
        this._socket.close();
    }

    public void finalize() {
        this.close();
    }
}

