/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.websocket;

import de.ponton.securelistener.administration.CommandRequest;
import de.ponton.securelistener.administration.CommandResponse;
import de.ponton.xmlpipe.websocket.AbstractEndpoint;
import de.pontonconsulting.xmlpipe.events.ListenerConnected;
import jakarta.websocket.ClientEndpoint;
import jakarta.websocket.CloseReason;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.RemoteEndpoint;
import jakarta.websocket.WebSocketContainer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

@ClientEndpoint
public class ConfigEndpoint
extends AbstractEndpoint
implements MessageHandler.Whole<String>,
MessageHandler.Partial<byte[]> {
    static final Logger LOG = LogManager.getLogger((String)"Listener.ConfigEndpoint");
    private Map<String, String> responseHeaders = new HashMap<String, String>();
    private ByteArrayOutputStream responseData = new ByteArrayOutputStream();
    private final ApplicationEventPublisher applicationEventPublisher;
    private CompletableFuture<CommandResponse> responseCompletableFuture;
    private final String url;

    public ConfigEndpoint(WebSocketContainer container, String url, int reconnectDelay, PrivateKey key, X509Certificate cert, ApplicationEventPublisher applicationEventPublisher, String authenticationId) {
        super(container, url, reconnectDelay, key, cert, authenticationId);
        this.applicationEventPublisher = applicationEventPublisher;
        this.url = url;
    }

    public synchronized CommandResponse sendCommand(CommandRequest commandRequest) {
        RemoteEndpoint.Basic basicRemoteEndpoint = this.session.getBasicRemote();
        String headersString = commandRequest.getHeadersAsString();
        CommandResponse commandResponse = null;
        try {
            this.resetCachedData();
            LOG.trace("sending Request: {}", (Object)commandRequest.getHeader("command"));
            basicRemoteEndpoint.sendText(headersString);
            byte[] requestData = commandRequest.getData();
            if (requestData == null) {
                requestData = new byte[]{};
            }
            CompletableFuture<CommandResponse> responseFuture = this.sendDataAndWaitForResponse(requestData, basicRemoteEndpoint);
            return responseFuture.get(TIME_OUT_IN_MILLISECONDS, TimeUnit.MILLISECONDS);
        }
        catch (IOException | ExecutionException | TimeoutException e) {
            LOG.error("could not send command {}", (Object)e.toString());
            commandResponse = this.createErrorResultAndCloseSession(e);
        }
        catch (InterruptedException e) {
            LOG.error("send command was interrupted. {}", (Object)e.toString());
            Thread.currentThread().interrupt();
            commandResponse = this.createErrorResultAndCloseSession(e);
        }
        return commandResponse;
    }

    private CommandResponse createErrorResultAndCloseSession(Exception e) {
        HashMap<String, CallSite> headers = new HashMap<String, CallSite>();
        headers.put("X-Error", (CallSite)((Object)("Could not send command. " + e.toString())));
        CommandResponse commandResponse = new CommandResponse(headers, new byte[0]);
        this.closeSession(CloseReason.CloseCodes.VIOLATED_POLICY, "could not send command");
        return commandResponse;
    }

    private CompletableFuture<CommandResponse> sendDataAndWaitForResponse(byte[] requestData, RemoteEndpoint.Basic basicRemoteEndpoint) throws IOException {
        this.responseCompletableFuture = new CompletableFuture();
        this.sendData(requestData, basicRemoteEndpoint);
        return this.responseCompletableFuture;
    }

    @Override
    void handleIncomingData(byte[] partialMessage, boolean last) throws IOException {
        if (last) {
            this.handleLastPacket(partialMessage);
        } else {
            this.handleDataPacket(partialMessage);
        }
    }

    private void handleLastPacket(byte[] partialMessage) {
        LOG.trace("received last packet: {}", (Object)partialMessage[0]);
        CommandResponse commandResponse = new CommandResponse(this.responseHeaders, this.responseData.toByteArray());
        this.responseCompletableFuture.complete(commandResponse);
    }

    private void handleDataPacket(byte[] partialMessage) {
        LOG.trace("receiving Request Data ({}bytes)", (Object)partialMessage.length);
        try {
            this.responseData.write(partialMessage);
        }
        catch (IOException e) {
            LOG.error("error while forwarding response data {}", (Object)e.toString());
        }
    }

    public void onMessage(String message) {
        LOG.trace("receiving Request Header");
        message.lines().forEach(headerLine -> {
            int separatorIndex = headerLine.indexOf(": ");
            if (separatorIndex > 0) {
                String headerName = headerLine.substring(0, separatorIndex);
                String headerValue = headerLine.substring(separatorIndex + 2);
                this.responseHeaders.put(headerName, headerValue);
            }
        });
    }

    private void resetCachedData() {
        this.responseHeaders.clear();
        this.responseData.reset();
    }

    @Override
    Logger getLogger() {
        return LOG;
    }

    @Override
    protected void onAuthenticationCompleted() {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ListenerConnected((Object)this));
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ConfigEndpoint that = (ConfigEndpoint)((Object)o);
        return Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hashCode(this.url);
    }
}

