/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.websocket;

import de.ponton.securelistener.administration.Constants;
import de.pontonconsulting.xmlpipe.config.listener.ListenerConfigException;
import jakarta.websocket.CloseReason;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.RemoteEndpoint;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.eclipse.jetty.ee10.websocket.jakarta.client.JakartaWebSocketClientContainer;
import org.eclipse.jetty.websocket.core.exception.UpgradeException;

public abstract class AbstractEndpoint
extends Endpoint
implements MessageHandler.Partial<byte[]> {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    public static int TIME_OUT_IN_MILLISECONDS = 30000;
    protected Session session;
    private ScheduledFuture<Boolean> reconnectThread;
    protected String url;
    private final WebSocketContainer container;
    private final PrivateKey key;
    private final X509Certificate cert;
    private final String authId;
    private final int reconnectDelay;
    private final int heartbeatInterval;
    private Throwable lastThrowable;
    private final AtomicBoolean isAuthenticated = new AtomicBoolean(false);
    private final AtomicBoolean reconnect = new AtomicBoolean(true);

    public AbstractEndpoint(WebSocketContainer container, String url, int reconnectDelay, PrivateKey key, X509Certificate cert, String authenticationId) {
        this.container = container;
        this.key = key;
        this.cert = cert;
        this.authId = authenticationId;
        this.url = url;
        this.reconnectDelay = reconnectDelay;
        this.heartbeatInterval = 30;
    }

    public void onMessage(byte[] partialMessage, boolean last) {
        if (this.isAuthenticated()) {
            try {
                this.handleIncomingData(partialMessage, last);
            }
            catch (IOException e) {
                this.getLogger().error("problem while forwarding data: {}", (Object)e.getMessage());
                this.closeSession(CloseReason.CloseCodes.VIOLATED_POLICY, "problem while forwarding data: " + e.getMessage());
            }
        } else {
            this.answerAuthenticationRequest(partialMessage);
        }
    }

    abstract void handleIncomingData(byte[] var1, boolean var2) throws IOException;

    private void answerAuthenticationRequest(byte[] partialMessage) {
        try {
            ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA512WITHRSA").build(this.key);
            CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
            gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build()).build(sha1Signer, this.cert));
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            certList.add(this.cert);
            JcaCertStore certs = new JcaCertStore(certList);
            gen.addCertificates((Store)certs);
            try (ByteArrayOutputStream fos = new ByteArrayOutputStream();){
                try (OutputStream sigOut = gen.open((OutputStream)fos);){
                    sigOut.write(partialMessage);
                }
                ByteBuffer buffer = ByteBuffer.wrap(fos.toByteArray());
                this.session.getBasicRemote().sendBinary(buffer, true);
                this.isAuthenticated.set(true);
                this.lastThrowable = null;
                this.onAuthenticationCompleted();
            }
            this.getLogger().debug("sent authentication with authentication id {}", (Object)this.authId);
        }
        catch (IOException | CertificateEncodingException | CMSException | OperatorCreationException e) {
            this.getLogger().error("could not create authentication response {}", (Object)e.toString());
            this.closeSession(CloseReason.CloseCodes.VIOLATED_POLICY, "authentication response problem");
        }
    }

    protected void onAuthenticationCompleted() {
    }

    abstract Logger getLogger();

    protected void closeSession(CloseReason.CloseCodes closeCode, String closeReason) {
        try {
            if (this.session != null) {
                this.session.close(new CloseReason((CloseReason.CloseCode)closeCode, closeReason));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void connect() throws DeploymentException, IOException, URISyntaxException {
        try {
            if (this.container instanceof JakartaWebSocketClientContainer && !((JakartaWebSocketClientContainer)this.container).isStarted()) {
                throw new IOException("websocket container is not ready.");
            }
            this.getLogger().debug("connecting to {}", (Object)this.url);
            this.container.connectToServer((Object)this, new URI(this.url));
        }
        catch (IOException e) {
            this.lastThrowable = this.findRootCause(e);
            throw e;
        }
        catch (DeploymentException | URISyntaxException e) {
            this.lastThrowable = e;
            throw e;
        }
    }

    public void shutdown() {
        this.reconnect.set(false);
        this.cancelReconnectThread();
        this.closeSession(CloseReason.CloseCodes.NORMAL_CLOSURE, "shutdown");
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated.get();
    }

    public Future<Boolean> reconnect() {
        return this.reconnect(0);
    }

    private void cancelReconnectThread() {
        if (this.reconnectThread != null) {
            this.reconnectThread.cancel(true);
        }
    }

    private Future<Boolean> reconnect(int delay) {
        this.cancelReconnectThread();
        this.reconnectThread = scheduler.schedule(() -> {
            try {
                this.connect();
                Thread.sleep(50L);
                return this.isAuthenticated();
            }
            catch (IOException e) {
                Exception rootCause = this.findRootCause(e);
                this.getLogger().error("could not connect to Listener: {}", (Object)rootCause.toString());
                this.reconnectThread = null;
                this.reconnect(this.reconnectDelay);
            }
            catch (DeploymentException | URISyntaxException e) {
                this.getLogger().error("could not connect to Listener: {}", (Object)e.toString());
                this.reconnectThread = null;
                this.reconnect(this.reconnectDelay);
            }
            catch (Exception e) {
                this.getLogger().error("Unexpected error while reconnect", (Throwable)e);
            }
            return Boolean.FALSE;
        }, (long)delay, TimeUnit.SECONDS);
        return this.reconnectThread;
    }

    private Exception findRootCause(Exception e) {
        if (e.getCause() instanceof Exception) {
            return this.findRootCause((Exception)e.getCause());
        }
        return e;
    }

    public void onOpen(Session session, EndpointConfig config) {
        this.isAuthenticated.set(false);
        this.session = session;
        session.addMessageHandler((MessageHandler)this);
        session.setMaxIdleTimeout((long)this.heartbeatInterval * 2000L);
        this.getLogger().info("successfully connected to {} ", (Object)this.url);
        this.sendHeartbeat();
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.session = null;
        this.isAuthenticated.set(false);
        if ("Messenger instance not authorized".equals(closeReason.getReasonPhrase())) {
            this.getLogger().error("Listener rejected connection. Add this authentication id {} to list of authorized instances", (Object)this.authId);
            this.lastThrowable = new ListenerConfigException(47001, "Messenger instance not authorized");
        } else {
            this.getLogger().error("Connection to Listener was closed (trying to reconnect after 1s): {} {}", (Object)closeReason.getCloseCode(), (Object)closeReason.getReasonPhrase());
            this.reconnect(1);
        }
    }

    public void onError(Session session, Throwable cause) {
        this.lastThrowable = cause;
        if (cause instanceof IOException || cause instanceof TimeoutException || cause instanceof UpgradeException) {
            if (cause.getCause() != null) {
                this.getLogger().error("WebSocket Error: session {} {} cause:{}", (Object)session, (Object)cause.toString(), (Object)cause.getCause().toString());
            } else {
                this.getLogger().error("WebSocket Error: session {} {}", (Object)session, (Object)cause.toString());
            }
        } else {
            this.getLogger().error("WebSocket Error: session {}", (Object)session, (Object)cause);
        }
        this.closeSession(CloseReason.CloseCodes.VIOLATED_POLICY, "WebSocket Error: " + cause.toString());
    }

    public Throwable getLastThrowable() {
        return this.lastThrowable;
    }

    private void sendHeartbeat() {
        scheduler.schedule(() -> {
            if (this.session != null) {
                try {
                    this.session.getBasicRemote().sendPong(ByteBuffer.wrap("heartbeat from messenger".getBytes()));
                    this.sendHeartbeat();
                }
                catch (IOException | IllegalArgumentException e) {
                    this.getLogger().error("WebSocket Error: session {} {}", (Object)this.session, (Object)e.toString());
                    this.closeSession(CloseReason.CloseCodes.VIOLATED_POLICY, "WebSocket Error: " + e.toString());
                }
                catch (Exception e) {
                    this.getLogger().error("Unexpected error while sending a heatbeat", (Throwable)e);
                }
            }
        }, (long)this.heartbeatInterval, TimeUnit.SECONDS);
        this.getLogger().debug("[{}] Next heartbeat in {} seconds.", (Object)this.session.getId(), (Object)this.heartbeatInterval);
    }

    protected void sendData(byte[] data, RemoteEndpoint.Basic basicRemoteEndpoint) throws IOException {
        byte[] buffer = new byte[64000];
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        int len = 0;
        block4: while (len > -1) {
            len = in.read(buffer);
            switch (len) {
                case -1: {
                    this.getLogger().trace("sending transmission complete trigger");
                    basicRemoteEndpoint.sendBinary(ByteBuffer.wrap(Constants.TRANSMISSION_OK), true);
                    continue block4;
                }
                case 0: {
                    continue block4;
                }
            }
            this.getLogger().trace("sending Data ({}bytes)", (Object)len);
            basicRemoteEndpoint.sendBinary(ByteBuffer.wrap(buffer, 0, len), false);
        }
    }

    public String getUrl() {
        return this.url;
    }
}

