/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.user;

import de.ponton.xmlpipe.rest.RequestUtils;
import de.ponton.xmlpipe.rest.user.DisableTotpDto;
import de.ponton.xmlpipe.rest.user.EnableTotpDto;
import de.ponton.xmlpipe.rest.user.GenerateTotpSecretDto;
import de.ponton.xmlpipe.rest.user.PasswordChangeConstraint;
import de.ponton.xmlpipe.rest.user.TotpEnabledDto;
import de.ponton.xmlpipe.rest.user.TotpSecretDto;
import de.ponton.xmlpipe.rest.user.UserDto;
import de.ponton.xmlpipe.rest.user.UserDtoFactory;
import de.ponton.xmlpipe.rest.user.UserPasswordDto;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerUser;
import de.pontonconsulting.xmlpipe.security.InvalidTotpException;
import de.pontonconsulting.xmlpipe.security.acegi.PontonPasswordEncoder;
import de.pontonconsulting.xmlpipe.security.acegi.PontonUserDetailsServiceImpl;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.security.Principal;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user"})
@Validated
public class UserSettingsController {
    public static final String DOCUMENTATION_TAG = "User Settings";
    private static final Logger AUDIT = LogManager.getLogger((String)("Audit." + UserSettingsController.class.getName()));
    private final PontonUserDetailsServiceImpl userDetailsService;
    private final UserDtoFactory userDtoFactory;
    private final PontonPasswordEncoder passwordEncoder;

    public UserSettingsController(PontonUserDetailsServiceImpl userDetailsService, UserDtoFactory userDtoFactory, PontonPasswordEncoder passwordEncoder) {
        this.userDetailsService = userDetailsService;
        this.userDtoFactory = userDtoFactory;
        this.passwordEncoder = passwordEncoder;
    }

    @Operation(summary="Get the User", description="permission:USER_GET<br><br>Return the user", tags={"User Settings"})
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    @GetMapping
    @Secured(value={"USER_GET"})
    public ResponseEntity<UserDto> getUser(Principal principal) {
        return ResponseEntity.ok((Object)this.userDtoFactory.create(this.userDetailsService.loadUserByUsername(principal.getName())));
    }

    @Operation(summary="Return the language", description="permission:USER_LANGUAGE_GET<br><br>Get the user configured language", tags={"User Settings"})
    @ApiResponses(value={@ApiResponse(responseCode="200")})
    @GetMapping(value={"/language"})
    @Secured(value={"USER_LANGUAGE_GET"})
    public ResponseEntity<String> getUserLanguage(Principal principal) {
        MessengerUser userDetails = this.userDetailsService.loadUserByUsername(principal.getName());
        return ResponseEntity.ok((Object)(userDetails.getLanguage() != null ? userDetails.getLanguage() : ""));
    }

    @Operation(summary="Set language", description="permission:USER_LANGUAGE_PUT<br><br>Set a new language for the user", tags={"User Settings"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="language was was successfully set")})
    @PutMapping(value={"/language"})
    @Secured(value={"USER_LANGUAGE_PUT"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> setUserLanguage(Principal principal, @NotBlank @RequestBody String language) {
        this.userDetailsService.setLanguageForUser(principal.getName(), language);
        AUDIT.info("{'{}', '{}' -> '{}'} User changed: Language for user '{}'. Language set: '{}'.", (Object)principal.getName(), (Object)RequestUtils.getRemoteAddress(), (Object)RequestUtils.getLocalAddress(), (Object)principal.getName(), (Object)language);
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Reset language", description="permission:USER_LANGUAGE_DELETE<br><br>Reset the language to the default value", tags={"User Settings"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="language was was successfully reset")})
    @DeleteMapping(value={"/language"})
    @Secured(value={"USER_LANGUAGE_DELETE"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> resetUserLanguage(Principal principal) {
        this.userDetailsService.setLanguageForUser(principal.getName(), null);
        AUDIT.info("{'{}', '{}' -> '{}'} User changed: Language for user '{}' restored to default.", (Object)principal.getName(), (Object)RequestUtils.getRemoteAddress(), (Object)RequestUtils.getLocalAddress(), (Object)principal.getName());
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Change password", description="permission:USER_PASSWORD_POST<br><br>Change the password for the user", tags={"User Settings"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="password was successfully changed")})
    @PostMapping(value={"/password"})
    @Secured(value={"USER_PASSWORD_POST"})
    @PasswordChangeConstraint
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> changePassword(Principal principal, @Valid @RequestBody UserPasswordDto userPasswordDto) throws Exception {
        if (!userPasswordDto.getNewPassword().equals("***")) {
            this.userDetailsService.setPasswordForUser(principal.getName(), userPasswordDto.getNewPassword(), false);
        }
        AUDIT.info("{'{}', '{}' -> '{}'} User changed: Password for user '{}'.", (Object)principal.getName(), (Object)RequestUtils.getRemoteAddress(), (Object)RequestUtils.getLocalAddress(), (Object)principal.getName());
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/generateTotpSecret"})
    @Operation(summary="Enter your one time code to enable two factor authentication", description="permission:USER_GENERATE_TOTP_SECRET_POST<br><br>permission:USER_GENERATE_TOTP_SECRET_POST<br><br>Enter your one time code to enable two factor authentication.", tags={"User Settings"})
    @Secured(value={"USER_GENERATE_TOTP_SECRET_POST"})
    public ResponseEntity<TotpSecretDto> generateTotpSecret(Principal principal, @Valid @RequestBody GenerateTotpSecretDto generateTotpSecretDto) {
        String username = principal.getName();
        if (this.userDetailsService.isTotpEnabled(username)) {
            throw new RuntimeException("TOTP already enabled. You need to disable it to regenerate a secret.");
        }
        this.validateCurrentPassword(username, generateTotpSecretDto.getPassword());
        String secret = this.userDetailsService.generateTotpSecret();
        this.userDetailsService.updateTotpSecret(username, secret);
        AUDIT.info("{'{}', '{}' -> '{}'} User changed: Multi-Factor Authentication Secret for user '{}' generated.", (Object)principal.getName(), (Object)RequestUtils.getRemoteAddress(), (Object)RequestUtils.getLocalAddress(), (Object)principal.getName());
        return ResponseEntity.ok((Object)new TotpSecretDto(secret));
    }

    @PostMapping(value={"/enableTotp"})
    @Operation(summary="Enter your password to start setup for two factor authentication", description="permission:USER_ENABLE_TOTP_POST<br><br>Enter your password to start setup for two factor authentication.", tags={"User Settings"})
    @Secured(value={"USER_ENABLE_TOTP_POST"})
    public ResponseEntity<Void> enableTotp(Principal principal, @Valid @RequestBody EnableTotpDto enableTotpDto) {
        String username = principal.getName();
        if (this.userDetailsService.isTotpEnabled(username)) {
            throw new RuntimeException("TOTP already enabled. You need to disable it to regenerate a secret.");
        }
        if (!this.userDetailsService.isValidTotp(username, enableTotpDto.getTotp())) {
            throw new InvalidTotpException("Invalid TOTP");
        }
        this.userDetailsService.updateTotpEnabled(username, true);
        AUDIT.info("{'{}', '{}' -> '{}'} User changed: Multi-Factor Authentication for user '{}' enabled.", (Object)principal.getName(), (Object)RequestUtils.getRemoteAddress(), (Object)RequestUtils.getLocalAddress(), (Object)principal.getName());
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/disableTotp"})
    @Operation(summary="Enter your password to disable two factor authentication", description="permission:USER_DISABLE_TOTP_POST<br><br>Enter your password to disable two factor authentication.", tags={"User Settings"})
    @Secured(value={"USER_DISABLE_TOTP_POST"})
    public ResponseEntity<Void> disableTotp(Principal principal, @Valid @RequestBody DisableTotpDto disableTotpDto) {
        String username = principal.getName();
        if (!this.userDetailsService.isTotpEnabled(username)) {
            throw new RuntimeException("TOTP not enabled.");
        }
        this.validateCurrentPassword(username, disableTotpDto.getPassword());
        this.userDetailsService.updateTotpSecret(username, null);
        this.userDetailsService.updateTotpEnabled(username, false);
        AUDIT.info("{'{}', '{}' -> '{}'} User changed: Multi-Factor Authentication for user '{}' disabled.", (Object)principal.getName(), (Object)RequestUtils.getRemoteAddress(), (Object)RequestUtils.getLocalAddress(), (Object)principal.getName());
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/permissions"})
    public ResponseEntity<List<String>> getPermissions() {
        return ResponseEntity.of(Optional.of(SecurityContextHolder.getContext().getAuthentication().getAuthorities().stream().map(GrantedAuthority::getAuthority).toList()));
    }

    @GetMapping(value={"/isTotpEnabled"})
    @Operation(summary="Show if two factor authentication is activated", description="permission:USER_IS_TOTP_ENABLED_GET<br><br>Show if two factor authentication is activated.", tags={"User Settings"})
    @Secured(value={"USER_IS_TOTP_ENABLED_GET"})
    public ResponseEntity<TotpEnabledDto> isTotpEnabled(Principal principal) {
        return ResponseEntity.ok((Object)new TotpEnabledDto(this.userDetailsService.isTotpEnabled(principal.getName()), this.userDetailsService.isTwoFactorsEnforced()));
    }

    private void validateCurrentPassword(String username, String password) {
        MessengerUser userDetails = this.userDetailsService.loadUserByUsername(username);
        if (!this.passwordEncoder.matches(password, userDetails.getPassword())) {
            throw new BadCredentialsException("Password invalid");
        }
    }
}

