/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.user;

import de.ponton.xmlpipe.rest.user.PasswordChangeConstraint;
import de.ponton.xmlpipe.rest.user.UserPasswordDto;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerUser;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerUserDAO;
import de.pontonconsulting.xmlpipe.security.acegi.PontonPasswordEncoder;
import de.pontonconsulting.xmlpipe.security.acegi.PontonUserDetailsServiceImpl;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraintvalidation.SupportedValidationTarget;
import jakarta.validation.constraintvalidation.ValidationTarget;
import java.security.Principal;

@SupportedValidationTarget(value={ValidationTarget.PARAMETERS})
public class PasswordChangeValidator
implements ConstraintValidator<PasswordChangeConstraint, Object[]> {
    private final PontonUserDetailsServiceImpl userDetailsService;
    private final PontonPasswordEncoder passwordEncoder;
    private final MessengerUserDAO messengerUserDAO;
    private String noMatchValidationMessage;
    private String reusedValidationMessage;

    public PasswordChangeValidator(PontonUserDetailsServiceImpl userDetailsService, PontonPasswordEncoder passwordEncoder, MessengerUserDAO messengerUserDAO) {
        this.userDetailsService = userDetailsService;
        this.passwordEncoder = passwordEncoder;
        this.messengerUserDAO = messengerUserDAO;
    }

    public boolean isValid(Object[] value, ConstraintValidatorContext context) {
        Principal principal = (Principal)value[0];
        UserPasswordDto userPasswordDto = (UserPasswordDto)value[1];
        MessengerUser userDetails = this.userDetailsService.loadUserByUsername(principal.getName());
        if (!this.passwordEncoder.matches(userPasswordDto.getCurrentPassword(), userDetails.getPassword())) {
            context.buildConstraintViolationWithTemplate(this.noMatchValidationMessage).addPropertyNode("currentPassword").addConstraintViolation().disableDefaultConstraintViolation();
            return false;
        }
        if (this.isPasswordAlreadyUsed(userDetails.getUsername(), userPasswordDto.getNewPassword())) {
            context.buildConstraintViolationWithTemplate(this.reusedValidationMessage).addPropertyNode("newPassword").addConstraintViolation().disableDefaultConstraintViolation();
            return false;
        }
        return true;
    }

    public void initialize(PasswordChangeConstraint constraintAnnotation) {
        this.noMatchValidationMessage = constraintAnnotation.messageNoMatch();
        this.reusedValidationMessage = constraintAnnotation.messageReused();
    }

    private boolean isPasswordAlreadyUsed(String username, String password) {
        return this.messengerUserDAO.isPasswordAlreadyUsed(username, password);
    }
}

