/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.status;

import de.ponton.xmlpipe.rest.status.MessengerStatusDto;
import de.ponton.xmlpipe.rest.status.MessengerStatusService;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/status/messenger"})
@Validated
public class MessengerStatusController {
    public static final String DOCUMENTATION_TAG = "Status";
    private final MessengerStatusService messengerStatusService;
    private final ReferenceDateTask referenceDateTask;

    public MessengerStatusController(MessengerStatusService messengerStatusService, ReferenceDateTask referenceDateTask) {
        this.messengerStatusService = messengerStatusService;
        this.referenceDateTask = referenceDateTask;
    }

    @Operation(summary="Restarts Messenger", description="permission:STATUS_MESSENGER_RESTART_GET<br><br>Restart the messenger server.", tags={"Status"})
    @GetMapping(value={"/restart"})
    @Secured(value={"STATUS_MESSENGER_RESTART_GET"})
    public ResponseEntity<Void> restartMessenger() {
        this.messengerStatusService.restartMessenger();
        return ResponseEntity.ok().build();
    }

    @Operation(summary="Download Config files", description="permission:STATUS_MESSENGER_DOWNLOAD_CONFIG_FILES_GET<br><br>Returns all messenger config files compressed in a zip file.", tags={"Status"})
    @GetMapping(value={"/downloadConfigFiles"})
    @Secured(value={"STATUS_MESSENGER_DOWNLOAD_CONFIG_FILES_GET"})
    public void downloadConfigFiles(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.messengerStatusService.getMessengerConfigFiles(httpServletRequest, httpServletResponse);
        httpServletResponse.setStatus(200);
    }

    @Operation(summary="Upload of an exported config file zip", description="permission:STATUS_MESSENGER_UPLOAD_CONFIG_FILES_POST<br><br>Installs uploaded config files, which has been exported before. Existing partners and agreements not included in uploaded file, will remain untouched", tags={"Status"})
    @PostMapping(path={"/uploadConfigFileZip"}, consumes={"multipart/form-data"})
    @Secured(value={"STATUS_MESSENGER_UPLOAD_CONFIG_FILES_POST"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> uploadConfigFileZip(@RequestParam MultipartFile configFileZip) throws IOException {
        this.messengerStatusService.installConfigFileZip(configFileZip);
        this.messengerStatusService.restartMessenger();
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Download Log files", description="permission:STATUS_MESSENGER_DOWNLOAD_LOG_FILES_GET<br><br>Returns all messenger log files compressed in a zip file.", tags={"Status"})
    @GetMapping(value={"/downloadLogFiles"})
    @Secured(value={"STATUS_MESSENGER_DOWNLOAD_LOG_FILES_GET"})
    public void downloadLogs(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.messengerStatusService.getMessengerLogs(httpServletRequest, httpServletResponse);
        httpServletResponse.setStatus(200);
    }

    @GetMapping
    @Operation(summary="Get the status of the messenger", description="permission:STATUS_MESSENGER_GET", tags={"Status"})
    @Secured(value={"STATUS_MESSENGER_GET"})
    public ResponseEntity<MessengerStatusDto> getMessengerStatus() {
        return ResponseEntity.ok((Object)this.messengerStatusService.getMessengerStatus());
    }

    @GetMapping(value={"/synchronizeNTPTime"})
    @Operation(summary="Forces NTP Time Synchronization", description="permission:STATUS_MESSENGER_SYNCHRONIZED_NTP_TIME_GET", tags={"Status"})
    @Secured(value={"STATUS_MESSENGER_SYNCHRONIZED_NTP_TIME_GET"})
    public ResponseEntity<Void> synchronizeNTPTime() {
        this.referenceDateTask.updateNow();
        return ResponseEntity.ok().build();
    }
}

