/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.status;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(description="Status information of the messenger", name="Status.Messenger.Info")
public class MessengerInfoDto {
    @Schema(description="ID of the Messenger installation")
    @TrimmedField
    private String id;
    @Schema(description="Version of the Messenger installation")
    @TrimmedField
    private String version;
    @Schema(description="Timestamp when the Messenger version was built")
    @TrimmedField
    private String buildDate;
    @Schema(description="Validity of the Messenger license activation")
    private boolean validActivation;
    @Schema(description="Indicates how many days the license is still valid")
    private long activationDaysLeft;
    @Schema(description="Name of the used java virtual machine")
    @TrimmedField
    private String javaVirtualMachine;
    @Schema(description="Vendor of the used java virtual machine")
    @TrimmedField
    private String javaVendor;
    @Schema(description="Version of the used java virtual machine")
    @TrimmedField
    private String javaVersion;
    @Schema(description="Name of the used operation system")
    @TrimmedField
    private String operationSystem;
    @Schema(description="Version of operation system")
    @TrimmedField
    private String operationSystemVersion;
    @Schema(description="Hostname or IP adress of the used NTP server")
    @TrimmedField
    private String referenceNTPServer;
    @Schema(description="Reference date of the nto server")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private OffsetDateTime referenceDate;
    @Schema(description="Offset in milliseconds from the local date to the reference date")
    private long localSystemTimeOffset;

    public String getId() {
        return this.id;
    }

    public MessengerInfoDto setId(String id) {
        this.id = id;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public MessengerInfoDto setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    public MessengerInfoDto setBuildDate(String buildDate) {
        this.buildDate = buildDate;
        return this;
    }

    public boolean isValidActivation() {
        return this.validActivation;
    }

    public MessengerInfoDto setValidActivation(boolean validActivation) {
        this.validActivation = validActivation;
        return this;
    }

    public long getActivationDaysLeft() {
        return this.activationDaysLeft;
    }

    public MessengerInfoDto setActivationDaysLeft(long activationDaysLeft) {
        this.activationDaysLeft = activationDaysLeft;
        return this;
    }

    public String getJavaVirtualMachine() {
        return this.javaVirtualMachine;
    }

    public MessengerInfoDto setJavaVirtualMachine(String javaVirtualMachine) {
        this.javaVirtualMachine = javaVirtualMachine;
        return this;
    }

    public String getJavaVendor() {
        return this.javaVendor;
    }

    public MessengerInfoDto setJavaVendor(String javaVendor) {
        this.javaVendor = javaVendor;
        return this;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public MessengerInfoDto setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
        return this;
    }

    public String getOperationSystem() {
        return this.operationSystem;
    }

    public MessengerInfoDto setOperationSystem(String operationSystem) {
        this.operationSystem = operationSystem;
        return this;
    }

    public String getOperationSystemVersion() {
        return this.operationSystemVersion;
    }

    public MessengerInfoDto setOperationSystemVersion(String operationSystemVersion) {
        this.operationSystemVersion = operationSystemVersion;
        return this;
    }

    public String getReferenceNTPServer() {
        return this.referenceNTPServer;
    }

    public MessengerInfoDto setReferenceNTPServer(String referenceNTPServer) {
        this.referenceNTPServer = referenceNTPServer;
        return this;
    }

    public OffsetDateTime getReferenceDate() {
        return this.referenceDate;
    }

    public MessengerInfoDto setReferenceDate(OffsetDateTime referenceDate) {
        this.referenceDate = referenceDate;
        return this;
    }

    public long getLocalSystemTimeOffset() {
        return this.localSystemTimeOffset;
    }

    public MessengerInfoDto setLocalSystemTimeOffset(long localSystemTimeOffset) {
        this.localSystemTimeOffset = localSystemTimeOffset;
        return this;
    }
}

