/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.status;

import de.ponton.xmlpipe.rest.status.ListenerStatusDto;
import de.ponton.xmlpipe.websocket.ConfigEndpoint;
import de.pontonconsulting.xmlpipe.config.ListenerConfig;
import de.pontonconsulting.xmlpipe.config.listener.GetStatus;
import de.pontonconsulting.xmlpipe.config.listener.ListenerConfigException;
import java.net.URI;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ListenerStatusService {
    public static final String NA = "---";
    private final ListenerConfig listenerConfig;
    private final List<ConfigEndpoint> configEndpoints;

    public ListenerStatusService(ListenerConfig listenerConfig) {
        this.listenerConfig = listenerConfig;
        this.configEndpoints = listenerConfig.getConfigEndpoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ListenerStatusDto> getListenerStatus() {
        ArrayList<ListenerStatusDto> listenerStatusDtos = new ArrayList<ListenerStatusDto>();
        List<ConfigEndpoint> list = this.configEndpoints;
        synchronized (list) {
            for (ConfigEndpoint configEndpoint : this.configEndpoints) {
                URI uri = URI.create(configEndpoint.getUrl());
                try {
                    GetStatus status = this.listenerConfig.getStatus(configEndpoint);
                    listenerStatusDtos.add(new ListenerStatusDto().setHost(uri.getHost() + ":" + uri.getPort()).setVersion(status.getListenerVersion()).setUptime((System.currentTimeMillis() - status.getUptime()) / 1000L).setHttp(status.getHttp()).setHttps(status.getHttps()).setHttpsClientCertificateCheckEnabled(Boolean.parseBoolean(status.getHttpsClientCertCheck())).setHttpsClientCertificateAuthEnabled(Boolean.parseBoolean(status.getHttpsClientCertAuth())).setTotalMessageCount(Long.parseLong(status.getMessageCount())).setLastMessageReceivedAt(status.getLastMessageTime() != 0L ? Instant.ofEpochMilli(status.getLastMessageTime()).atOffset(ZoneOffset.UTC) : null).setLastMessageOriginIp(status.getLastMessageIP().equals("na") ? null : status.getLastMessageIP()).setHttpProxyServer(status.getProxy().equals(NA) ? null : status.getProxy()));
                }
                catch (ListenerConfigException e) {
                    listenerStatusDtos.add(new ListenerStatusDto().setHost(uri.getHost() + ":" + uri.getPort()));
                }
            }
        }
        return listenerStatusDtos;
    }
}

