/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.status;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(description="Status information of the listener", name="Status.Listener")
public class ListenerStatusDto {
    @Schema(description="Host of the Listener installation")
    private String host;
    @Schema(description="Version of the Listener installation")
    @TrimmedField
    private String version;
    @Schema(description="Uptime of the Listener, measured in seconds")
    private long uptime;
    @Schema(description="HTTP listening address and port. Format is 'address:port' or 'deactivated' when http is disabled")
    @TrimmedField
    private String http;
    @Schema(description="HTTPS listening address and port. Format is 'address:port' or 'deactivated' when https is disabled")
    @TrimmedField
    private String https;
    @Schema(description="Status of the https client certificate check. Only valid when HTTPS listening address and port is enabled")
    private boolean httpsClientCertificateCheckEnabled;
    @Schema(description="Status of the https client authentication. Only valid when HTTPS listening address and port is enabled")
    private boolean httpsClientCertificateAuthEnabled;
    @Schema(description="Number of messages received since start of the listener")
    private long totalMessageCount;
    @Schema(description="Timestamp when the last message was received")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private OffsetDateTime lastMessageReceivedAt;
    @Schema(description="IP Address of the origin of the last message")
    @TrimmedField
    private String lastMessageOriginIp;
    @Schema(description="Address and port of the used http proxy server. Format is 'address:port'")
    @TrimmedField
    private String httpProxyServer;

    public String getVersion() {
        return this.version;
    }

    public ListenerStatusDto setVersion(String version) {
        this.version = version;
        return this;
    }

    public long getUptime() {
        return this.uptime;
    }

    public ListenerStatusDto setUptime(long uptime) {
        this.uptime = uptime;
        return this;
    }

    public String getHttp() {
        return this.http;
    }

    public ListenerStatusDto setHttp(String http) {
        this.http = http;
        return this;
    }

    public String getHttps() {
        return this.https;
    }

    public ListenerStatusDto setHttps(String https) {
        this.https = https;
        return this;
    }

    public boolean isHttpsClientCertificateCheckEnabled() {
        return this.httpsClientCertificateCheckEnabled;
    }

    public ListenerStatusDto setHttpsClientCertificateCheckEnabled(boolean httpsClientCertificateCheckEnabled) {
        this.httpsClientCertificateCheckEnabled = httpsClientCertificateCheckEnabled;
        return this;
    }

    public long getTotalMessageCount() {
        return this.totalMessageCount;
    }

    public ListenerStatusDto setTotalMessageCount(long totalMessageCount) {
        this.totalMessageCount = totalMessageCount;
        return this;
    }

    public OffsetDateTime getLastMessageReceivedAt() {
        return this.lastMessageReceivedAt;
    }

    public ListenerStatusDto setLastMessageReceivedAt(OffsetDateTime lastMessageReceivedAt) {
        this.lastMessageReceivedAt = lastMessageReceivedAt;
        return this;
    }

    public String getLastMessageOriginIp() {
        return this.lastMessageOriginIp;
    }

    public ListenerStatusDto setLastMessageOriginIp(String lastMessageOriginIp) {
        this.lastMessageOriginIp = lastMessageOriginIp;
        return this;
    }

    public String getHttpProxyServer() {
        return this.httpProxyServer;
    }

    public ListenerStatusDto setHttpProxyServer(String httpProxyServer) {
        this.httpProxyServer = httpProxyServer;
        return this;
    }

    public boolean isHttpsClientCertificateAuthEnabled() {
        return this.httpsClientCertificateAuthEnabled;
    }

    public ListenerStatusDto setHttpsClientCertificateAuthEnabled(boolean httpsClientCertificateAuthEnabled) {
        this.httpsClientCertificateAuthEnabled = httpsClientCertificateAuthEnabled;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public ListenerStatusDto setHost(String host) {
        this.host = host;
        return this;
    }
}

