/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.status;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(description="Information about current node in messenger cluster", name="Status.Cluster.Info")
public class ClusterInfoDto {
    @Schema(description="The instance ID of cluster node")
    @TrimmedField
    private String id;
    @Schema(description="ID of the current MessengerCluster")
    @TrimmedField
    private String clusterId;
    @Schema(description="The instance alias of cluster node")
    @TrimmedField
    private String alias;
    @Schema(description="The Messenger ID of cluster node")
    private int messengerId;
    @Schema(description="The current IP address of cluster node")
    @TrimmedField
    private String ipAddress;
    @Schema(description="Last startup time of cluster node")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private OffsetDateTime lastStartup;
    @Schema(description="Last heart beat time of cluster node")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private OffsetDateTime lastHeartBeat;
    @Schema(description="The current IP address of cluster node")
    @TrimmedField
    private String status;
    @Schema(description="This flag indicates if this Messenger is currently handling the global tasks")
    @TrimmedField
    private Boolean handlingGlobalTasks;
    @Schema(description="This flag indicates if this is the node that answered the REST request")
    @TrimmedField
    private Boolean thisNode;

    public String getId() {
        return this.id;
    }

    public ClusterInfoDto setId(String id) {
        this.id = id;
        return this;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public ClusterInfoDto setClusterId(String clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    public String getAlias() {
        return this.alias;
    }

    public ClusterInfoDto setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public int getMessengerId() {
        return this.messengerId;
    }

    public ClusterInfoDto setMessengerId(int messengerId) {
        this.messengerId = messengerId;
        return this;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public ClusterInfoDto setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public OffsetDateTime getLastStartup() {
        return this.lastStartup;
    }

    public ClusterInfoDto setLastStartup(OffsetDateTime lastStartup) {
        this.lastStartup = lastStartup;
        return this;
    }

    public OffsetDateTime getLastHeartBeat() {
        return this.lastHeartBeat;
    }

    public ClusterInfoDto setLastHeartBeat(OffsetDateTime lastHeartBeat) {
        this.lastHeartBeat = lastHeartBeat;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public ClusterInfoDto setStatus(String status) {
        this.status = status;
        return this;
    }

    public Boolean isHandlingGlobalTasks() {
        return this.handlingGlobalTasks;
    }

    public ClusterInfoDto setHandlingGlobalTasks(Boolean globalTasks) {
        this.handlingGlobalTasks = globalTasks;
        return this;
    }

    public Boolean isThisNode() {
        return this.thisNode;
    }

    public ClusterInfoDto setThisNode(Boolean thisNode) {
        this.thisNode = thisNode;
        return this;
    }
}

