/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.statistics;

import de.ponton.xmlpipe.metrics.MetricsService;
import de.ponton.xmlpipe.metrics.XPMetrics;
import de.ponton.xmlpipe.rest.exception.ExceptionDto;
import de.ponton.xmlpipe.rest.exception.ExceptionDtoFactory;
import de.ponton.xmlpipe.rest.statistics.MessagesStatisticsDto;
import de.ponton.xmlpipe.rest.statistics.MeterDto;
import de.ponton.xmlpipe.rest.statistics.MeterDtoFactory;
import de.ponton.xmlpipe.rest.statistics.UtilizationMeterDto;
import de.ponton.xmlpipe.rest.statistics.UtilizationMeterDtoFactory;
import de.ponton.xmlpipe.rest.statistics.UtilizationTimerDto;
import de.ponton.xmlpipe.rest.statistics.UtilizationTimerDtoFactory;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import io.swagger.v3.oas.annotations.Operation;
import java.util.concurrent.TimeUnit;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/statistics"})
@Validated
public class StatisticsController {
    public static final String DOCUMENTATION_TAG = "Statistics";
    private final MetricsService metricsService;
    private final MeterDtoFactory meterDtoFactory;
    private final UtilizationMeterDtoFactory utilizationMeterDtoFactory;
    private final UtilizationTimerDtoFactory utilizationTimerDtoFactory;
    private final Profiles profiles;
    private final ExceptionDtoFactory exceptionDtoFactory;

    public StatisticsController(MetricsService metricsService, MeterDtoFactory meterDtoFactory, UtilizationMeterDtoFactory utilizationMeterDtoFactory, UtilizationTimerDtoFactory utilizationTimerDtoFactory, Profiles profiles, ExceptionDtoFactory exceptionDtoFactory) {
        this.metricsService = metricsService;
        this.meterDtoFactory = meterDtoFactory;
        this.utilizationMeterDtoFactory = utilizationMeterDtoFactory;
        this.utilizationTimerDtoFactory = utilizationTimerDtoFactory;
        this.profiles = profiles;
        this.exceptionDtoFactory = exceptionDtoFactory;
    }

    @Operation(summary="Get Total Messages", description="permission:STATISTICS_MESSAGES_GET<br><br>Get Total Messages metrics", tags={"Statistics"})
    @Secured(value={"STATISTICS_MESSAGES_GET"})
    @GetMapping(value={"/messages"})
    public ResponseEntity<MessagesStatisticsDto> getMessagesStatistics() {
        MessagesStatisticsDto messagesStatisticsDto = new MessagesStatisticsDto().setInboundFailed(this.getMeterFromFactory(XPMetrics.MESSAGES_INBOUND_FAILED)).setInboundSuccessful(this.getMeterFromFactory(XPMetrics.MESSAGES_INBOUND_SUCCESSFUL)).setOutboundFailed(this.getMeterFromFactory(XPMetrics.MESSAGES_OUTBOUND_FAILED)).setOutboundSuccessful(this.getMeterFromFactory(XPMetrics.MESSAGES_OUTBOUND_SUCCESSFUL)).setOutboundRetries(this.metricsService.getMeter(XPMetrics.MESSAGES_OUTBOUND_RETRIES).getCount()).setOutboundTransmissionTime(this.convertMicroseconds((long)this.metricsService.getTimer(XPMetrics.MESSAGES_OUTBOUND_TIME).getSnapshot().getMedian(), TimeUnit.SECONDS)).setInboundQueueAddRate(this.getUtilizationMeterFromFactory(XPMetrics.MESSAGES_INBOUND_QUEUE_ADD_RATE)).setInboundQueueRemoveRate(this.getUtilizationMeterFromFactory(XPMetrics.MESSAGES_INBOUND_QUEUE_REMOVE_RATE)).setInboundListenerToQueueTime(this.getUtilizationTimerFromFactory(XPMetrics.MESSAGES_INBOUND_LISTENER_QUEUE_TIME)).setInboundQueueToAdapterTime(this.getUtilizationTimerFromFactory(XPMetrics.MESSAGES_INBOUND_QUEUE_ADAPTER_TIME)).setOutboundQueueAddRate(this.getUtilizationMeterFromFactory(XPMetrics.MESSAGES_OUTBOUND_QUEUE_ADD_RATE)).setOutboundQueueRemoveRate(this.getUtilizationMeterFromFactory(XPMetrics.MESSAGES_OUTBOUND_QUEUE_REMOVE_RATE)).setOutboundAdapterToQueueTime(this.getUtilizationTimerFromFactory(XPMetrics.MESSAGES_OUTBOUND_ADAPTER_QUEUE_TIME)).setOutboundQueueToPartnerTime(this.getUtilizationTimerFromFactory(XPMetrics.MESSAGES_OUTBOUND_QUEUE_PARTNER_TIME));
        return ResponseEntity.ok((Object)messagesStatisticsDto);
    }

    @Operation(summary="Get Messages Statistics for partner", description="permission:STATISTICS_MESSAGES_GET<br><br>Get total messages metrics for partner", tags={"Statistics"})
    @Secured(value={"STATISTICS_MESSAGES_GET"})
    @GetMapping(value={"/messages/{id}"})
    public ResponseEntity<MessagesStatisticsDto> getMessagesStatistics(@PathVariable String id) throws ProfileException {
        this.profiles.getProfileForLocalId(id, true);
        MessagesStatisticsDto messagesStatisticsDto = new MessagesStatisticsDto().setInboundReceiverFailed(this.getMeterFromFactory(XPMetrics.MESSAGES_INBOUND_RECEIVER_FAILED, id)).setInboundReceiverSuccessful(this.getMeterFromFactory(XPMetrics.MESSAGES_INBOUND_RECEIVER_SUCCESSFUL, id)).setInboundSenderFailed(this.getMeterFromFactory(XPMetrics.MESSAGES_INBOUND_SENDER_FAILED, id)).setInboundSenderSuccessful(this.getMeterFromFactory(XPMetrics.MESSAGES_INBOUND_SENDER_SUCCESSFUL, id)).setOutboundReceiverFailed(this.getMeterFromFactory(XPMetrics.MESSAGES_OUTBOUND_RECEIVER_FAILED, id)).setOutboundReceiverSuccessful(this.getMeterFromFactory(XPMetrics.MESSAGES_OUTBOUND_RECEIVER_SUCCESSFUL, id)).setOutboundSenderFailed(this.getMeterFromFactory(XPMetrics.MESSAGES_OUTBOUND_SENDER_FAILED, id)).setOutboundSenderSuccessful(this.getMeterFromFactory(XPMetrics.MESSAGES_OUTBOUND_SENDER_SUCCESSFUL, id)).setOutboundRetries(this.metricsService.getMeter(XPMetrics.MESSAGES_OUTBOUND_RETRIES, id).getCount()).setOutboundTransmissionTime(this.convertMicroseconds((long)this.metricsService.getTimer(XPMetrics.MESSAGES_OUTBOUND_TIME, id).getSnapshot().getMedian(), TimeUnit.SECONDS)).setInboundQueueAddRate(this.getUtilizationMeterFromFactory(XPMetrics.MESSAGES_INBOUND_QUEUE_ADD_RATE, id)).setInboundQueueRemoveRate(this.getUtilizationMeterFromFactory(XPMetrics.MESSAGES_INBOUND_QUEUE_REMOVE_RATE, id)).setInboundListenerToQueueTime(this.getUtilizationTimerFromFactory(XPMetrics.MESSAGES_INBOUND_LISTENER_QUEUE_TIME, id)).setInboundQueueToAdapterTime(this.getUtilizationTimerFromFactory(XPMetrics.MESSAGES_INBOUND_QUEUE_ADAPTER_TIME, id)).setOutboundQueueAddRate(this.getUtilizationMeterFromFactory(XPMetrics.MESSAGES_OUTBOUND_QUEUE_ADD_RATE, id)).setOutboundQueueRemoveRate(this.getUtilizationMeterFromFactory(XPMetrics.MESSAGES_OUTBOUND_QUEUE_REMOVE_RATE, id)).setOutboundAdapterToQueueTime(this.getUtilizationTimerFromFactory(XPMetrics.MESSAGES_OUTBOUND_ADAPTER_QUEUE_TIME, id)).setOutboundQueueToPartnerTime(this.getUtilizationTimerFromFactory(XPMetrics.MESSAGES_OUTBOUND_QUEUE_PARTNER_TIME, id));
        return ResponseEntity.ok((Object)messagesStatisticsDto);
    }

    @ExceptionHandler(value={ProfileNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseEntity<ExceptionDto> handleNotFound(Exception e) {
        Throwable cause = e;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(cause), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    private MeterDto getMeterFromFactory(XPMetrics metricName) {
        return this.meterDtoFactory.create(this.metricsService.getMeter(metricName));
    }

    private MeterDto getMeterFromFactory(XPMetrics metricName, String partnerId) {
        return this.meterDtoFactory.create(this.metricsService.getMeter(metricName, partnerId));
    }

    private UtilizationMeterDto getUtilizationMeterFromFactory(XPMetrics metricName) {
        return this.utilizationMeterDtoFactory.create(this.metricsService.getMeter(metricName));
    }

    private UtilizationMeterDto getUtilizationMeterFromFactory(XPMetrics metricName, String partnerId) {
        return this.utilizationMeterDtoFactory.create(this.metricsService.getMeter(metricName, partnerId));
    }

    private UtilizationTimerDto getUtilizationTimerFromFactory(XPMetrics metricName) {
        return this.utilizationTimerDtoFactory.create(this.metricsService.getTimer(metricName));
    }

    private UtilizationTimerDto getUtilizationTimerFromFactory(XPMetrics metricName, String partnerId) {
        return this.utilizationTimerDtoFactory.create(this.metricsService.getTimer(metricName, partnerId));
    }

    private long convertMicroseconds(long microseconds, TimeUnit newUnit) {
        return microseconds / newUnit.toMicros(1L);
    }
}

