/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.messagequeue;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the message queue configuration of the messenger.")
public class MessageQueueDto {
    @NotNull
    @Min(value=500L)
    @Max(value=60000L)
    @Schema(description="Specifies the interval in milliseconds to scan the inbound message queue. The default setting is 5000 ms. For higher throughput you can decrease this value.")
    private @NotNull @Min(value=500L) @Max(value=60000L) Integer inboundQueueScanInterval;
    @NotNull
    @Min(value=5L)
    @Max(value=3600L)
    @Schema(description="Specifies the delivery timeout in seconds to the local adapter. The default setting is 300 seconds (5 minutes).")
    private @NotNull @Min(value=5L) @Max(value=3600L) Integer inboundQueueDeliveryTimeout;
    @NotNull
    @Min(value=10L)
    @Max(value=3600L)
    @Schema(description="Specifies the delay time in seconds between the deliveries to the local adapter. The default setting is 60 seconds.")
    private @NotNull @Min(value=10L) @Max(value=3600L) Integer inboundQueueRetryDelay;
    @NotNull
    @Min(value=500L)
    @Max(value=60000L)
    @Schema(description="Specifies the interval in milliseconds to scan the outbound message queue. The default setting is 5000 ms. For higher throughput you can decrease this value.")
    private @NotNull @Min(value=500L) @Max(value=60000L) Integer outboundQueueScanInterval;

    public Integer getInboundQueueScanInterval() {
        return this.inboundQueueScanInterval;
    }

    public MessageQueueDto setInboundQueueScanInterval(Integer inboundQueueScanInterval) {
        this.inboundQueueScanInterval = inboundQueueScanInterval;
        return this;
    }

    public Integer getInboundQueueDeliveryTimeout() {
        return this.inboundQueueDeliveryTimeout;
    }

    public MessageQueueDto setInboundQueueDeliveryTimeout(Integer inboundQueueDeliveryTimeout) {
        this.inboundQueueDeliveryTimeout = inboundQueueDeliveryTimeout;
        return this;
    }

    public Integer getInboundQueueRetryDelay() {
        return this.inboundQueueRetryDelay;
    }

    public MessageQueueDto setInboundQueueRetryDelay(Integer inboundQueueRetryDelay) {
        this.inboundQueueRetryDelay = inboundQueueRetryDelay;
        return this;
    }

    public Integer getOutboundQueueScanInterval() {
        return this.outboundQueueScanInterval;
    }

    public MessageQueueDto setOutboundQueueScanInterval(Integer outboundQueueScanInterval) {
        this.outboundQueueScanInterval = outboundQueueScanInterval;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessageQueueDto)) {
            return false;
        }
        MessageQueueDto that = (MessageQueueDto)o;
        return Objects.equals(this.inboundQueueScanInterval, that.inboundQueueScanInterval) && Objects.equals(this.inboundQueueDeliveryTimeout, that.inboundQueueDeliveryTimeout) && Objects.equals(this.inboundQueueRetryDelay, that.inboundQueueRetryDelay) && Objects.equals(this.outboundQueueScanInterval, that.outboundQueueScanInterval);
    }

    public int hashCode() {
        return Objects.hash(this.inboundQueueScanInterval, this.inboundQueueDeliveryTimeout, this.inboundQueueRetryDelay, this.outboundQueueScanInterval);
    }

    public String toString() {
        return "MessageQueueDto{inboundQueueScanInterval=" + this.inboundQueueScanInterval + ", inboundQueueDeliveryTimeout=" + this.inboundQueueDeliveryTimeout + ", inboundQueueRetryDelay=" + this.inboundQueueRetryDelay + ", outboundQueueScanInterval=" + this.outboundQueueScanInterval + "}";
    }
}

