/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.email.notification;

import de.ponton.xmlpipe.rest.IDtoFactory;
import de.ponton.xmlpipe.rest.settings.email.notification.CronExpressionDto;
import de.ponton.xmlpipe.rest.settings.email.notification.EmailNotificationDto;
import de.ponton.xmlpipe.rest.settings.email.notification.message.MessageEventReceiverDto;
import de.ponton.xmlpipe.rest.settings.email.notification.system.SystemEventReceiverDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.notification.XpCronExpressionDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.notification.XpEmailNotificationDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.notification.message.XpMessageEventReceiverDto;
import de.pontonconsulting.xmlpipe.config.model.messenger.email.notification.system.XpSystemEventReceiverDto;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class MessengerConfigurationEmailNotificationFactory
implements IDtoFactory<EmailNotificationDto, XpEmailNotificationDto> {
    private final IDtoFactory<SystemEventReceiverDto, XpSystemEventReceiverDto> systemEventReceiverFactory;
    private final IDtoFactory<MessageEventReceiverDto, XpMessageEventReceiverDto> messageEventReceiverFactory;

    public MessengerConfigurationEmailNotificationFactory(IDtoFactory<SystemEventReceiverDto, XpSystemEventReceiverDto> systemEventReceiverFactory, IDtoFactory<MessageEventReceiverDto, XpMessageEventReceiverDto> messageEventReceiverFactory) {
        this.systemEventReceiverFactory = Objects.requireNonNull(systemEventReceiverFactory, "MessengerConfigurationEmailNotificationFactory requires SystemEventReceiverFactory.");
        this.messageEventReceiverFactory = Objects.requireNonNull(messageEventReceiverFactory, "MessengerConfigurationEmailNotificationFactory requires MessageEventReceiverFactory.");
    }

    @Override
    public EmailNotificationDto create(XpEmailNotificationDto valueObject) {
        EmailNotificationDto dto = new EmailNotificationDto().setCronExpressions(valueObject.getCronExpressions().stream().map(expression -> new CronExpressionDto().setCronExpression(expression.getCronExpression()).setMaxNotificationPerMail(expression.getMaxNotificationPerMail())).collect(Collectors.toList())).setMessageEventReceivers(valueObject.getMessageEventReceivers().stream().map(this.messageEventReceiverFactory::create).collect(Collectors.toList())).setSystemEventReceivers(valueObject.getSystemEventReceivers().stream().map(this.systemEventReceiverFactory::create).collect(Collectors.toList()));
        return dto;
    }

    @Override
    public XpEmailNotificationDto parse(EmailNotificationDto valueObject) {
        XpEmailNotificationDto dto = new XpEmailNotificationDto().setCronExpressions(valueObject.getCronExpressions().stream().map(expression -> new XpCronExpressionDto().setCronExpression(expression.getCronExpression()).setMaxNotificationPerMail(expression.getMaxNotificationPerMail())).collect(Collectors.toList())).setMessageEventReceivers(valueObject.getMessageEventReceivers().stream().map(this.messageEventReceiverFactory::parse).collect(Collectors.toList())).setSystemEventReceivers(valueObject.getSystemEventReceivers().stream().map(this.systemEventReceiverFactory::parse).collect(Collectors.toList()));
        return dto;
    }
}

