/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.email;

import de.ponton.xmlpipe.rest.settings.email.EmailTestRequestDto;
import de.ponton.xmlpipe.rest.settings.email.EmailTestResultDto;
import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.transport.SmtpSender;
import de.pontonconsulting.xmlpipe.messenger.transport.SmtpSenderFactory;
import jakarta.mail.AuthenticationFailedException;
import jakarta.mail.MessagingException;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.springframework.stereotype.Component;

@Component
public class EmailTestService {
    private final SmtpSenderFactory smtpSenderFactory;
    private final MessengerConfig messengerConfig;

    public EmailTestService(SmtpSenderFactory smtpSenderFactory, MessengerConfig messengerConfig) {
        this.smtpSenderFactory = smtpSenderFactory;
        this.messengerConfig = messengerConfig;
    }

    public EmailTestResultDto sendTestMessage(EmailTestRequestDto emailTestRequest) {
        String subject = "Testmessage from " + Constants.getXP_NAME() + " Version " + Constants.getXP_VERSION();
        String msg = "Hello!\n\nThis is a testmessage from " + Constants.getXP_NAME() + " Version " + Constants.getXP_VERSION() + "\n\nBest regards\nYour Ponton X/P Messenger";
        try {
            SmtpSender smtpSender = this.smtpSenderFactory.getSmtpSender(emailTestRequest.getFrom() == null ? this.messengerConfig.getSmtpFromAddress() : emailTestRequest.getFrom(), emailTestRequest.getServer() == null ? this.messengerConfig.getSmtpServerHost() : emailTestRequest.getServer(), emailTestRequest.getProtocol() == null ? this.messengerConfig.getSmtpServerProtocol() : emailTestRequest.getProtocol(), emailTestRequest.getUser() == null ? this.messengerConfig.getSmtpUser() : emailTestRequest.getUser(), emailTestRequest.getPassword() == null ? this.messengerConfig.getSmtpPassword() : emailTestRequest.getPassword());
            smtpSender.sendMessage(emailTestRequest.getTo(), subject, msg);
        }
        catch (AuthenticationFailedException e) {
            return new EmailTestResultDto().setMessage("Server rejected Username or Password.").setMessageId("smtp.server.rejected.username.or.password").setFailed(true);
        }
        catch (MessagingException e) {
            Exception u = e.getNextException();
            if (u != null && u instanceof UnknownHostException) {
                return new EmailTestResultDto().setMessage("Server name cannot be resolved.").setMessageId("smtp.servername.cannot.be.resolved").setFailed(true);
            }
            if (u != null && u instanceof SocketException) {
                return new EmailTestResultDto().setMessage("Could not connect to SMTP server.").setMessageId("could.not.connect.to.smtp.server").setFailed(true);
            }
            return new EmailTestResultDto().setMessage(e.getMessage()).setFailed(true);
        }
        catch (Exception e) {
            return new EmailTestResultDto().setMessage(e.getMessage()).setFailed(true);
        }
        return new EmailTestResultDto().setMessage(String.format("Successfully sent a test email to '%s'.", emailTestRequest.getTo())).setMessageId("email.testemail.success").setFailed(false);
    }
}

