/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.email;

import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.settings.common.authentication.AuthenticationDto;
import de.ponton.xmlpipe.rest.settings.email.EmailInboundProtocol;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.net.URI;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the email inbound configuration of the messenger for receiving emails.")
public class EmailInboundDto {
    @NotNull
    @Schema(description="These settings configure your email server for incoming messages (via SMTP). POP3 and IMAP servers are both supported.")
    private EmailInboundProtocol protocol;
    @NotNull
    @Schema(description="The hostname or IP address of your POP3/IMAP server.")
    private URI host;
    @NotNull
    @Min(value=0L)
    @Max(value=86400L)
    @Schema(description="Enter a polling interval in seconds. This setting determines how often the Messenger should check for new messages. Polling can be disabled by setting '0' as value.")
    private @NotNull @Min(value=0L) @Max(value=86400L) Integer interval;
    @NotNull
    @Valid
    @Schema(description="The authentication information for the POP3/IMAP server.")
    private AuthenticationDto authentication;
    @NotBlank
    @Size(max=128)
    @Schema(description="You can define a non default folder within the mailbox. This is mainly used with IMAP servers. Leaving the default value (INBOX) will be correct in most cases.")
    @TrimmedField
    private @NotBlank @Size(max=128) String inboxFolderName;

    public EmailInboundProtocol getProtocol() {
        return this.protocol;
    }

    public EmailInboundDto setProtocol(EmailInboundProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public URI getHost() {
        return this.host;
    }

    public EmailInboundDto setHost(URI host) {
        this.host = host;
        return this;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public EmailInboundDto setInterval(Integer interval) {
        this.interval = interval;
        return this;
    }

    public AuthenticationDto getAuthentication() {
        return this.authentication;
    }

    public EmailInboundDto setAuthentication(AuthenticationDto authentication) {
        this.authentication = authentication;
        return this;
    }

    public String getInboxFolderName() {
        return this.inboxFolderName;
    }

    public EmailInboundDto setInboxFolderName(String inboxFolderName) {
        this.inboxFolderName = inboxFolderName;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmailInboundDto)) {
            return false;
        }
        EmailInboundDto that = (EmailInboundDto)o;
        return this.protocol == that.protocol && Objects.equals(this.host, that.host) && Objects.equals(this.interval, that.interval) && Objects.equals(this.authentication, that.authentication) && Objects.equals(this.inboxFolderName, that.inboxFolderName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.protocol, this.host, this.interval, this.authentication, this.inboxFolderName});
    }

    public String toString() {
        return "EmailInboundDto{protocol=" + String.valueOf((Object)this.protocol) + ", host=" + String.valueOf(this.host) + ", interval=" + this.interval + ", authentication=" + String.valueOf(this.authentication) + ", inboxFolderName='" + this.inboxFolderName + "'}";
    }
}

