/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.database;

import de.ponton.xmlpipe.rest.settings.database.ConnectionTestRequestDto;
import de.ponton.xmlpipe.rest.settings.database.ConnectionTestResultDto;
import de.pontonconsulting.xmlpipe.messenger.database.DatabaseBean;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DatabaseConnectionService {
    private final Logger logger = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    private static final long TIMEOUT = 5000L;
    private final DatabaseBean databaseBean;
    private final ExecutorService restExecutorService;

    public DatabaseConnectionService(DatabaseBean databaseBean, @Qualifier(value="restExecutorService") ExecutorService restExecutorService) {
        this.databaseBean = databaseBean;
        this.restExecutorService = restExecutorService;
    }

    public void reconnectDatabase() throws Exception {
        this.databaseBean.reconnectDatabase();
    }

    public ConnectionTestResultDto testConnection(ConnectionTestRequestDto connectionTestRequestDto) {
        try {
            ConnectionTestTask task = new ConnectionTestTask(connectionTestRequestDto.getUrl(), connectionTestRequestDto.getUsername(), connectionTestRequestDto.getPassword());
            Future<ConnectionTestResultDto> future = this.restExecutorService.submit(task);
            return future.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage());
            Thread.currentThread().interrupt();
            return new ConnectionTestResultDto().setFailed(true).setException(e.getClass().getName()).setErrorMessage(e.getMessage());
        }
        catch (ExecutionException | TimeoutException e) {
            this.logger.error(e.getMessage());
            return new ConnectionTestResultDto().setFailed(true).setException(e.getClass().getName()).setErrorMessage(e.getMessage());
        }
    }

    private static class ConnectionTestTask
    implements Callable<ConnectionTestResultDto> {
        private final Logger logger = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
        private final String url;
        private final String user;
        private final String pass;

        public ConnectionTestTask(String url, String user, String pass) {
            this.url = url;
            this.user = user;
            this.pass = pass;
        }

        @Override
        public ConnectionTestResultDto call() throws Exception {
            ConnectionTestResultDto connectionTestResultDto;
            block11: {
                this.logger.debug("Testing database connection to {} with user {}", (Object)this.url, (Object)this.user);
                Connection conn = DriverManager.getConnection(this.url, this.user, this.pass);
                try {
                    boolean changeTransactionIsolationLevel = false;
                    int usedTransactionIsolationLevel = conn.getTransactionIsolation();
                    if (2 != usedTransactionIsolationLevel && conn.getMetaData().supportsTransactionIsolationLevel(2)) {
                        changeTransactionIsolationLevel = true;
                    }
                    connectionTestResultDto = new ConnectionTestResultDto().setFailed(false).setChangeTransactionIsolationLevel(changeTransactionIsolationLevel);
                    if (conn == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.error(e.getClass().getSimpleName() + " while testing database connection: " + e.getMessage(), (Throwable)e);
                        } else {
                            this.logger.error(e.getClass().getSimpleName() + " while testing database connection to '" + this.url + "': " + e.getMessage(), (Throwable)e);
                        }
                        return new ConnectionTestResultDto().setException(e.getClass().getName()).setErrorMessage(e.getMessage()).setFailed(true);
                    }
                }
                conn.close();
            }
            return connectionTestResultDto;
        }
    }
}

