/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.common.authentication;

import de.ponton.xmlpipe.rest.jackson.ObfuscatedField;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the username and password for the authentication.")
public class AuthenticationDto {
    @NotBlank
    @Size(max=128)
    @Schema(description="The username for the login.")
    @TrimmedField
    private @NotBlank @Size(max=128) String username;
    @NotBlank
    @Size(max=128)
    @Schema(description="The password  for the login.")
    @ObfuscatedField
    private @NotBlank @Size(max=128) String password;

    public String getUsername() {
        return this.username;
    }

    public AuthenticationDto setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public AuthenticationDto setPassword(String password) {
        this.password = password;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthenticationDto)) {
            return false;
        }
        AuthenticationDto that = (AuthenticationDto)o;
        return Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password);
    }

    public String toString() {
        return "AuthenticationDto{username='" + this.username + "', password='" + this.password + "'}";
    }
}

