/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings.archive;

import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.settings.archive.ArchiverType;
import de.ponton.xmlpipe.rest.settings.archive.CleanupDto;
import de.ponton.xmlpipe.rest.settings.archive.MessagePart;
import de.ponton.xmlpipe.rest.validation.AdapterAccessConstraint;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import java.util.Set;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the archive configuration of the messenger.")
public class ArchiveDto {
    @Schema(description="The archive folder for successful messages. You can specify it as<ul><li>Absolute pathname to the required folder</li><li>Relative pathname beginning with '$PONTONXP_HOME' - this placeholder refers to the Messenger's 'data' folder</li>")
    @TrimmedField
    private String archiveFolder;
    @Schema(description="The archive folder for failed messages. You can specify it as<ul><li>Absolute pathname to the required folder</li><li>Relative pathname beginning with '$PONTONXP_HOME' - this placeholder refers to the Messenger's 'data' folder</li>")
    @TrimmedField
    private String archiveFailedFolder;
    @NotNull
    private ArchiverType archiverType;
    @Schema(description="AdapterId to be used for the archive if archiverType is WEB_SOCKET")
    @AdapterAccessConstraint
    private String adapterId;
    @Schema(description="Optional Zip compression reduces the space of the archive on disk. Set to true to enable zip compression, set to false to disable.")
    private boolean useZipCompression;
    @NotNull
    @Schema(description="A list of parts of a message which should be archived.")
    private Set<MessagePart> messageParts;
    @Valid
    @Schema(description="The cleanup configuration for the archive.")
    private CleanupDto archiveCleanup;

    public String getArchiveFolder() {
        return this.archiveFolder;
    }

    public ArchiveDto setArchiveFolder(String archiveFolder) {
        this.archiveFolder = archiveFolder;
        return this;
    }

    public String getArchiveFailedFolder() {
        return this.archiveFailedFolder;
    }

    public ArchiveDto setArchiveFailedFolder(String archiveFailedFolder) {
        this.archiveFailedFolder = archiveFailedFolder;
        return this;
    }

    public boolean isUseZipCompression() {
        return this.useZipCompression;
    }

    public ArchiveDto setUseZipCompression(boolean useZipCompression) {
        this.useZipCompression = useZipCompression;
        return this;
    }

    public Set<MessagePart> getMessageParts() {
        return this.messageParts;
    }

    public ArchiveDto setMessageParts(Set<MessagePart> messageParts) {
        this.messageParts = messageParts;
        return this;
    }

    public ArchiverType getArchiverType() {
        return this.archiverType;
    }

    public void setArchiverType(ArchiverType archiverType) {
        this.archiverType = archiverType;
    }

    public CleanupDto getArchiveCleanup() {
        return this.archiveCleanup;
    }

    public ArchiveDto setArchiveCleanup(CleanupDto archiveCleanup) {
        this.archiveCleanup = archiveCleanup;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArchiveDto)) {
            return false;
        }
        ArchiveDto that = (ArchiveDto)o;
        return this.useZipCompression == that.useZipCompression && Objects.equals(this.archiveFolder, that.archiveFolder) && Objects.equals(this.archiveFailedFolder, that.archiveFailedFolder) && Objects.equals(this.messageParts, that.messageParts) && Objects.equals(this.archiveCleanup, that.archiveCleanup) && Objects.equals((Object)this.archiverType, (Object)that.archiverType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.archiveFolder, this.archiveFailedFolder, this.useZipCompression, this.messageParts, this.archiveCleanup, this.archiverType});
    }

    public String toString() {
        return "ArchiveDto{archiveFolder='" + this.archiveFolder + "', archiveFailedFolder='" + this.archiveFailedFolder + "', useZipCompression=" + this.useZipCompression + ", messageParts=" + String.valueOf(this.messageParts) + ", archiveCleanup=" + String.valueOf(this.archiveCleanup) + ", archiverType=" + String.valueOf((Object)this.archiverType) + "}";
    }

    public String getAdapterId() {
        return this.adapterId;
    }

    public ArchiveDto setAdapterId(String adapterId) {
        this.adapterId = adapterId;
        return this;
    }
}

