/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.settings;

import de.ponton.xmlpipe.rest.settings.adapterapi.AdapterApiDto;
import de.ponton.xmlpipe.rest.settings.archive.ArchiveDto;
import de.ponton.xmlpipe.rest.settings.authtoken.AuthenticationTokenDto;
import de.ponton.xmlpipe.rest.settings.communication.CommunicationDto;
import de.ponton.xmlpipe.rest.settings.database.DatabaseDto;
import de.ponton.xmlpipe.rest.settings.display.DisplayDto;
import de.ponton.xmlpipe.rest.settings.email.EmailDto;
import de.ponton.xmlpipe.rest.settings.email.notification.EmailNotificationDto;
import de.ponton.xmlpipe.rest.settings.listener.ListenerDto;
import de.ponton.xmlpipe.rest.settings.logging.LoggingDto;
import de.ponton.xmlpipe.rest.settings.maintenance.MaintenanceDto;
import de.ponton.xmlpipe.rest.settings.messagequeue.MessageQueueDto;
import de.ponton.xmlpipe.rest.settings.partnerregistry.PartnerRegistryDto;
import de.ponton.xmlpipe.rest.settings.server.ServerDto;
import de.ponton.xmlpipe.rest.settings.timeserver.TimeServerDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the configuration of the messenger.")
public class MessengerConfigurationDto {
    @NotNull
    @Valid
    @Schema(description="The database configuration of the messenger.")
    private DatabaseDto database;
    @NotNull
    @Valid
    @Schema(description="The logging configuration of the messenger.")
    private LoggingDto logging;
    @NotNull
    @Valid
    @Schema(description="The message queue configuration of the messenger.")
    private MessageQueueDto messageQueue;
    @NotNull
    @Valid
    @Schema(description="The partner registry configuration of the messenger.")
    private PartnerRegistryDto partnerRegistry;
    @NotNull
    @Valid
    @Schema(description="The e-mail configuration of the messenger.")
    private EmailDto email;
    @NotNull
    @Valid
    @Schema(description="The e-mail notification configuration of the messenger.")
    private EmailNotificationDto emailNotification;
    @NotNull
    @Valid
    @Schema(description="The communication configuration of the messenger.")
    private CommunicationDto communication;
    @NotNull
    @Valid
    @Schema(description="The time server configuration of the messenger.")
    private TimeServerDto timeServer;
    @NotNull
    @Valid
    @Schema(description="The server configuration of the messenger.")
    private ServerDto server;
    @NotNull
    @Valid
    @Schema(description="The archive configuration of the messenger.")
    private ArchiveDto archive;
    @NotNull
    @Valid
    @Schema(description="The maintenance configuration of the messenger.")
    private MaintenanceDto maintenance;
    @NotNull
    @Valid
    @Schema(description="The listener connection configuration of the messenger.")
    private ListenerDto listener = new ListenerDto();
    @NotNull
    @Valid
    @Schema(description="The adapter api connection configuration of the messenger.")
    private AdapterApiDto adapterApi;
    @Valid
    @Schema(description="The messenger authentication token settings.")
    private AuthenticationTokenDto authenticationToken;
    @Valid
    @Schema(description="GUI display settings.")
    private DisplayDto display;

    public DatabaseDto getDatabase() {
        return this.database;
    }

    public MessengerConfigurationDto setDatabase(DatabaseDto database) {
        this.database = database;
        return this;
    }

    public LoggingDto getLogging() {
        return this.logging;
    }

    public MessengerConfigurationDto setLogging(LoggingDto logging) {
        this.logging = logging;
        return this;
    }

    public MessageQueueDto getMessageQueue() {
        return this.messageQueue;
    }

    public MessengerConfigurationDto setMessageQueue(MessageQueueDto messageQueue) {
        this.messageQueue = messageQueue;
        return this;
    }

    public PartnerRegistryDto getPartnerRegistry() {
        return this.partnerRegistry;
    }

    public MessengerConfigurationDto setPartnerRegistry(PartnerRegistryDto partnerRegistry) {
        this.partnerRegistry = partnerRegistry;
        return this;
    }

    public EmailDto getEmail() {
        return this.email;
    }

    public MessengerConfigurationDto setEmail(EmailDto email) {
        this.email = email;
        return this;
    }

    public EmailNotificationDto getEmailNotification() {
        return this.emailNotification;
    }

    public MessengerConfigurationDto setEmailNotification(EmailNotificationDto emailNotification) {
        this.emailNotification = emailNotification;
        return this;
    }

    public CommunicationDto getCommunication() {
        return this.communication;
    }

    public MessengerConfigurationDto setCommunication(CommunicationDto communication) {
        this.communication = communication;
        return this;
    }

    public TimeServerDto getTimeServer() {
        return this.timeServer;
    }

    public MessengerConfigurationDto setTimeServer(TimeServerDto timeServer) {
        this.timeServer = timeServer;
        return this;
    }

    public ServerDto getServer() {
        return this.server;
    }

    public MessengerConfigurationDto setServer(ServerDto server) {
        this.server = server;
        return this;
    }

    public ArchiveDto getArchive() {
        return this.archive;
    }

    public MessengerConfigurationDto setArchive(ArchiveDto archive) {
        this.archive = archive;
        return this;
    }

    public MaintenanceDto getMaintenance() {
        return this.maintenance;
    }

    public MessengerConfigurationDto setMaintenance(MaintenanceDto maintenance) {
        this.maintenance = maintenance;
        return this;
    }

    public ListenerDto getListener() {
        return this.listener;
    }

    public MessengerConfigurationDto setListener(ListenerDto listenerConnection) {
        this.listener = listenerConnection;
        return this;
    }

    public AdapterApiDto getAdapterApi() {
        return this.adapterApi;
    }

    public MessengerConfigurationDto setAdapterApi(AdapterApiDto adapterApi) {
        this.adapterApi = adapterApi;
        return this;
    }

    public AuthenticationTokenDto getAuthenticationToken() {
        return this.authenticationToken;
    }

    public MessengerConfigurationDto setAuthenticationToken(AuthenticationTokenDto authenticationToken) {
        this.authenticationToken = authenticationToken;
        return this;
    }

    public DisplayDto getDisplay() {
        return this.display;
    }

    public MessengerConfigurationDto setDisplay(DisplayDto display) {
        this.display = display;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessengerConfigurationDto)) {
            return false;
        }
        MessengerConfigurationDto that = (MessengerConfigurationDto)o;
        return Objects.equals(this.database, that.database) && Objects.equals(this.logging, that.logging) && Objects.equals(this.messageQueue, that.messageQueue) && Objects.equals(this.partnerRegistry, that.partnerRegistry) && Objects.equals(this.email, that.email) && Objects.equals(this.emailNotification, that.emailNotification) && Objects.equals(this.communication, that.communication) && Objects.equals(this.timeServer, that.timeServer) && Objects.equals(this.server, that.server) && Objects.equals(this.archive, that.archive) && Objects.equals(this.maintenance, that.maintenance) && Objects.equals(this.adapterApi, that.adapterApi) && Objects.equals(this.authenticationToken, that.authenticationToken) && Objects.equals(this.listener, that.listener) && Objects.equals(this.display, that.display);
    }

    public int hashCode() {
        return Objects.hash(this.database, this.logging, this.messageQueue, this.partnerRegistry, this.email, this.emailNotification, this.communication, this.timeServer, this.server, this.archive, this.maintenance, this.adapterApi, this.authenticationToken, this.display, this.listener);
    }

    public String toString() {
        return "MessengerConfigurationDto{database=" + String.valueOf(this.database) + ", logging=" + String.valueOf(this.logging) + ", messageQueue=" + String.valueOf(this.messageQueue) + ", partnerRegistry=" + String.valueOf(this.partnerRegistry) + ", email=" + String.valueOf(this.email) + ", emailNotification=" + String.valueOf(this.emailNotification) + ", communication=" + String.valueOf(this.communication) + ", timeServer=" + String.valueOf(this.timeServer) + ", server=" + String.valueOf(this.server) + ", archive=" + String.valueOf(this.archive) + ", maintenance=" + String.valueOf(this.maintenance) + ", listener=" + String.valueOf(this.listener) + ", adapterApi=" + String.valueOf(this.adapterApi) + ", authenticationToken=" + String.valueOf(this.authenticationToken) + ", display=" + String.valueOf(this.display) + "}";
    }
}

