/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.server.certificate;

import de.ponton.xmlpipe.rest.certificate.CertificateDto;
import de.ponton.xmlpipe.rest.certificate.CertificateDtoFactory;
import de.ponton.xmlpipe.rest.cpp.certificate.ExportKeyPairDto;
import de.ponton.xmlpipe.rest.cpp.certificate.ImportCertificateDto;
import de.ponton.xmlpipe.rest.cpp.certificate.ImportKeyPairDto;
import de.ponton.xmlpipe.rest.exception.ExceptionDto;
import de.ponton.xmlpipe.rest.exception.ExceptionDtoFactory;
import de.ponton.xmlpipe.rest.server.certificate.CreateServerCertificateRequestDto;
import de.ponton.xmlpipe.rest.server.certificate.ServerCertificateRequestDto;
import de.ponton.xmlpipe.rest.server.certificate.ServerCertificateService;
import de.pontonconsulting.xmlpipe.admintool.InstallCertException;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.Valid;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.operator.OperatorCreationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/server"})
@Validated
public class ServerCertificateController {
    public static final String DOCUMENTATION_TAG_SERVER_SSL_CERTIFICATE = "Server SSL Certificate";
    private final Logger log = LogManager.getLogger((String)("Messenger." + this.getClass().getSimpleName()));
    private final CertificateDtoFactory serverCertificateDtoFactory;
    private final ServerCertificateService serverCertificateService;
    private final ExceptionDtoFactory exceptionDtoFactory;

    public ServerCertificateController(CertificateDtoFactory serverCertificateDtoFactory, ServerCertificateService serverCertificateService, ExceptionDtoFactory exceptionDtoFactory) {
        this.serverCertificateDtoFactory = serverCertificateDtoFactory;
        this.serverCertificateService = serverCertificateService;
        this.exceptionDtoFactory = exceptionDtoFactory;
    }

    @Operation(summary="Get Server SSL certificate", description="permission:SERVER_CERTIFICATE_GET<br><br>Get the current Server SSL certificate", tags={"Server SSL Certificate"})
    @GetMapping(value={"/certificate"})
    @Secured(value={"SERVER_CERTIFICATE_GET"})
    public ResponseEntity<CertificateDto> getServerCertificate() throws KeyStoreException {
        return this.serverCertificateService.showServerCertificate().map(certificate -> ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)this.serverCertificateDtoFactory.create((X509Certificate)certificate))).orElseGet(() -> ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build());
    }

    @Operation(summary="Get Server SSL keystore", description="permission:SERVER_KEY_PAIR_GET<br><br>Get the current Server SSL keystore in PKCS12 Format", tags={"Server SSL Certificate"})
    @GetMapping(value={"/keypair"})
    @Secured(value={"SERVER_KEY_PAIR_GET"})
    public ResponseEntity<ExportKeyPairDto> getKeyPair(@RequestParam String password) throws GeneralSecurityException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.serverCertificateService.exportKeystore(byteArrayOutputStream, password);
        return ResponseEntity.ok((Object)new ExportKeyPairDto().setKeystore(Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray())));
    }

    @Operation(summary="Put Server SSL certificate", description="permission:SERVER_CERTIFICATE_PUT<br><br>Put Server SSL certificate from a Certificate Sign Request", tags={"Server SSL Certificate"})
    @PutMapping(value={"/certificate"})
    @Secured(value={"SERVER_CERTIFICATE_PUT"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> putCertificate(@Valid @RequestBody ImportCertificateDto importCertificateDto) throws Exception {
        this.serverCertificateService.installCertificate(importCertificateDto.getCertificateBase64(), importCertificateDto.getPassword());
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Put Server SSL PKCS12", description="permission:SERVER_KEY_PAIR_PUT<br><br>Put Server SSL certificate and PrivateKey from a PKCS12 keystore", tags={"Server SSL Certificate"})
    @PutMapping(value={"/keypair"})
    @Secured(value={"SERVER_KEY_PAIR_PUT"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public ResponseEntity<Void> putCertificate(@Valid @RequestBody ImportKeyPairDto importCertificateDto) throws Exception {
        this.serverCertificateService.installKeystore(importCertificateDto.getKeystore(), importCertificateDto.getPassword());
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/certificateRequest"})
    @Operation(summary="Server Certificate Sign Request", description="permission:SERVER_CERTIFICATE_REQUEST_POST<br><br>Create a Server Certificate Sign Request", tags={"Server SSL Certificate"})
    @Secured(value={"SERVER_CERTIFICATE_REQUEST_POST"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<ServerCertificateRequestDto> createCertificateRequest(@RequestBody @Valid CreateServerCertificateRequestDto createServerCertificateRequestDto) throws InstallCertException, GeneralSecurityException, IOException, OperatorCreationException {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.serverCertificateService.certificateSignRequest(createServerCertificateRequestDto));
    }

    @ExceptionHandler(value={KeyStoreException.class, InstallCertException.class, GeneralSecurityException.class})
    public ResponseEntity<ExceptionDto> handleBadRequest(Exception e) {
        this.log.error(String.format("Unexpected error when server configuration. Error: %s", e.getMessage()), (Throwable)e);
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }
}

