/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.registry;

import com.fasterxml.jackson.annotation.JsonFormat;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.registry.SyncState;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;

public class RegistryPartnerDto {
    @Schema(description="This is the file path of the partner profile stored in the partner registry.")
    @TrimmedField
    private String filePath;
    @Schema(description="This is the owner of the partner profile stored in the partner registry.")
    @TrimmedField
    private String owner;
    @Schema(description="This is the display name of the partner profile stored in the partner registry.")
    @TrimmedField
    private String displayName;
    @Schema(description="This is the date of the last modification of the partner profile stored in the partner registry.", nullable=true)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date lastModified;
    @Schema(description="This is the sync state of the partner profile stored in the partner registry.")
    private SyncState synced;
    @Schema(description="This is the partner id of the partner profile stored in the partner registry")
    @TrimmedField
    private String partnerId;

    public String getPartnerId() {
        return this.partnerId;
    }

    public RegistryPartnerDto setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public RegistryPartnerDto setFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public String getOwner() {
        return this.owner;
    }

    public RegistryPartnerDto setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public RegistryPartnerDto setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public RegistryPartnerDto setLastModified(Date lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public SyncState getSynced() {
        return this.synced;
    }

    public RegistryPartnerDto setSynced(SyncState synced) {
        this.synced = synced;
        return this;
    }
}

