/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.messagemulticastrule;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.ponton.xmlpipe.rest.messagemulticastrule.MessageMulticastInboundRule;
import de.ponton.xmlpipe.rest.messagemulticastrule.MessageMulticastRule;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerConfigDAO;
import jakarta.annotation.PostConstruct;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageMulticastRuleService {
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + MessageMulticastRuleService.class.getName()));
    protected static final String MESSAGE_MULTICAST_OUTBOUND_FILENAME = "messageMulticastRule.json";
    protected static final String MESSAGE_MULTICAST_INBOUND_FILENAME = "messageMulticastInboundRule.json";
    final IServerConfigBean serverConfig;
    private final Path messageMulticastOutboundRulePath;
    private final Path messageMulticastInboundRulePath;
    private final MessengerConfigDAO messengerConfigDAO;
    private final ObjectMapper objectMapper;
    protected TypeReference<List<MessageMulticastRule>> valueTypeRef = new TypeReference<List<MessageMulticastRule>>(this){};
    protected TypeReference<List<MessageMulticastInboundRule>> inboundValueTypeRef = new TypeReference<List<MessageMulticastInboundRule>>(this){};

    public MessageMulticastRuleService(IServerConfigBean serverConfig, MessengerConfigDAO messengerConfigDAO, ObjectMapper objectMapper) throws IOException {
        this.serverConfig = serverConfig;
        this.messengerConfigDAO = messengerConfigDAO;
        this.objectMapper = objectMapper;
        this.messageMulticastOutboundRulePath = Path.of(serverConfig.getConfigFolder().toPath().toString(), MESSAGE_MULTICAST_OUTBOUND_FILENAME);
        this.messageMulticastInboundRulePath = Path.of(serverConfig.getConfigFolder().toPath().toString(), MESSAGE_MULTICAST_INBOUND_FILENAME);
    }

    @PostConstruct
    public void postConstruct() throws IOException {
        if (Files.exists(this.messageMulticastOutboundRulePath, new LinkOption[0]) && !this.messengerConfigDAO.doesMessengerConfigExist(MESSAGE_MULTICAST_OUTBOUND_FILENAME)) {
            this.messengerConfigDAO.storeMessengerConfig(Files.readAllBytes(this.messageMulticastOutboundRulePath), MESSAGE_MULTICAST_OUTBOUND_FILENAME, "SYSTEM");
            Files.delete(this.messageMulticastOutboundRulePath);
        } else if (this.messengerConfigDAO.loadMessengerConfig(MESSAGE_MULTICAST_OUTBOUND_FILENAME) == null) {
            this.messengerConfigDAO.storeMessengerConfig("[]".getBytes(StandardCharsets.UTF_8), MESSAGE_MULTICAST_OUTBOUND_FILENAME, "SYSTEM");
        }
    }

    public List<MessageMulticastRule> getMessageMulticastOutboundRules() {
        try {
            return (List)this.objectMapper.readValue(this.messengerConfigDAO.loadMessengerConfig(MESSAGE_MULTICAST_OUTBOUND_FILENAME).getData(), this.valueTypeRef);
        }
        catch (IOException e) {
            LOG.error("Could not read Message Multicast Rules file. {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public synchronized void putMessageMulticastOutboundRules(List<MessageMulticastRule> messageMulticastRules, String username) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            outputStream.write(this.objectMapper.writeValueAsBytes(messageMulticastRules));
            this.messengerConfigDAO.storeMessengerConfig(outputStream.toByteArray(), MESSAGE_MULTICAST_OUTBOUND_FILENAME, username);
        }
        catch (IOException e) {
            LOG.error("Could not write Message Multicast Rules file. {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public List<MessageMulticastInboundRule> getMessageMulticastInboundRules() {
        try {
            return (List)this.objectMapper.readValue(Files.exists(this.messageMulticastInboundRulePath, new LinkOption[0]) ? Files.readString(this.messageMulticastInboundRulePath) : "[]", this.inboundValueTypeRef);
        }
        catch (IOException e) {
            LOG.error("Could not read Message Multicast Inbound Rules file. {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public synchronized void putMessageMulticastInboundRules(List<MessageMulticastInboundRule> messageMulticastInboundRules) {
        try (OutputStream outputStream = Files.newOutputStream(this.messageMulticastInboundRulePath, new OpenOption[0]);){
            outputStream.write(this.objectMapper.writeValueAsBytes(messageMulticastInboundRules));
        }
        catch (IOException e) {
            LOG.error("Could not write Message Multicast Inbound Rules file. {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

