/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.message;

import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.ponton.xmlpipe.rest.message.MessageDetailDto;
import de.ponton.xmlpipe.rest.message.MessageLogDto;
import de.ponton.xmlpipe.rest.message.MessageLogEvent;
import de.ponton.xmlpipe.rest.message.ProgressState;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessageLog;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class MessageDetailService {
    private static final Pattern PATTERN = Pattern.compile("<a href='(.+)'>(.*)</a>");
    private final HibernateSessionFactory hibernateSessionFactory;
    private final int maxMessageLogs;
    private final ArchiveProcessor archiveProcessor;

    public MessageDetailService(IMessengerProperties messengerProperties, HibernateSessionFactory hibernateSessionFactory, ArchiveProcessor archiveProcessor) {
        this.maxMessageLogs = Integer.parseInt(messengerProperties.getProperty("ponton.messenger.message_detail.limit", "40"));
        this.hibernateSessionFactory = hibernateSessionFactory;
        this.archiveProcessor = archiveProcessor;
    }

    public MessageDetailDto buildMessageDetailDto(long messageId) {
        try (EntityManager entityManager = this.hibernateSessionFactory.createNewEntityManager();){
            MessageDetailDto messageDetailDto;
            Message dbMessage = (Message)entityManager.find(Message.class, (Object)messageId);
            if (dbMessage == null) {
                throw new ResourceNotFoundException("Could not get message logs for unknown message with id " + messageId);
            }
            MessageDetailDto messageDetailDto2 = messageDetailDto = new MessageDetailDto().setMessageId(messageId).setMessageLogs(this.getMessageLogs(messageId, entityManager)).setProgressState(this.determineProgressState(dbMessage, entityManager)).setMessageArtifacts(this.archiveProcessor.listMessageArtifactsInArchive(messageId));
            return messageDetailDto2;
        }
    }

    private ProgressState determineProgressState(Message dbMessage, EntityManager entityManager) {
        boolean isInbound = dbMessage.getInbound() == 1;
        Integer dbStatus = dbMessage.getStatus();
        switch (dbStatus) {
            case 3: {
                return isInbound ? ProgressState.IN_DELIVERED_TO_ADAPTER : ProgressState.OUT_DELIVERED_TO_RECEIVER;
            }
            case 1: {
                return isInbound ? ProgressState.IN_RECEIVED_FROM_LISTENER : ProgressState.OUT_RECEIVED_FROM_ADAPTER;
            }
            case 2: {
                return isInbound ? ProgressState.IN_PROCESSED : ProgressState.OUT_PROCESSED;
            }
            case 5: {
                return ProgressState.OUT_RECEIVED_FROM_ADAPTER;
            }
            case 4: 
            case 6: {
                Optional<MessageLogEvent> logEventOptional = this.determineLastFailedLogEvent(dbMessage.getId(), entityManager);
                if (logEventOptional.isPresent()) {
                    return ProgressState.getProgressStateFor(logEventOptional.get(), isInbound);
                }
                return isInbound ? ProgressState.IN_PROCESSING_FAILED : ProgressState.OUT_PROCESSING_FAILED;
            }
        }
        return isInbound ? ProgressState.IN_PROCESSED : ProgressState.OUT_PROCESSED;
    }

    private Optional<MessageLogEvent> determineLastFailedLogEvent(long messageId, EntityManager entityManager) {
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = cb.createQuery(MessageLog.class);
        Root root = criteriaQuery.from(MessageLog.class);
        criteriaQuery.select((Selection)root);
        criteriaQuery.where(new Predicate[]{cb.equal((Expression)root.get("messageID"), (Object)messageId), cb.ge((Expression)root.get("logMessageID"), (Number)500)});
        criteriaQuery.orderBy(new Order[]{cb.asc((Expression)root.get("id"))});
        TypedQuery qry = entityManager.createQuery(criteriaQuery);
        qry.setFirstResult(0);
        qry.setMaxResults(1);
        List messageLogs = qry.getResultList();
        if (messageLogs != null && !messageLogs.isEmpty()) {
            return Optional.ofNullable(MessageLogEvent.ofEventId(((MessageLog)messageLogs.getFirst()).getLogMessageID()));
        }
        return Optional.empty();
    }

    private List<MessageLogDto> getMessageLogs(long messageId, EntityManager entityManager) {
        ArrayList<MessageLogDto> result = new ArrayList<MessageLogDto>();
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery countQuery = cb.createQuery(Long.class);
        Root root = countQuery.from(MessageLog.class);
        countQuery.select((Selection)cb.countDistinct((Expression)root));
        countQuery.where((Expression)cb.equal((Expression)root.get("messageID"), (Object)messageId));
        Long realCount = (Long)entityManager.createQuery(countQuery).getSingleResult();
        if (realCount.intValue() > this.maxMessageLogs) {
            int resultPart1Size = this.maxMessageLogs / 2;
            int resultPart2Size = this.maxMessageLogs - resultPart1Size;
            result.addAll(this.getMessageLogDtos(messageId, 0, resultPart1Size, entityManager));
            result.add(new MessageLogDto().setTimestamp(new Date(0L)).setEvent(MessageLogEvent.SEPARATOR).setAdditionalText("------------------------------"));
            result.addAll(this.getMessageLogDtos(messageId, realCount.intValue() - resultPart2Size, resultPart2Size, entityManager));
        } else {
            result.addAll(this.getMessageLogDtos(messageId, 0, realCount.intValue(), entityManager));
        }
        return result;
    }

    private List<MessageLogDto> getMessageLogDtos(long messageId, int firstResult, int maxResults, EntityManager entityManager) {
        ArrayList<MessageLogDto> result = new ArrayList<MessageLogDto>();
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery messageLogQuery = cb.createQuery(MessageLog.class);
        Root root = messageLogQuery.from(MessageLog.class);
        messageLogQuery.select((Selection)root);
        messageLogQuery.where((Expression)cb.equal((Expression)root.get("messageID"), (Object)messageId));
        messageLogQuery.orderBy(new Order[]{cb.asc((Expression)root.get("timestamp")), cb.asc((Expression)root.get("id"))});
        TypedQuery qry = entityManager.createQuery(messageLogQuery);
        qry.setFirstResult(firstResult);
        qry.setMaxResults(maxResults);
        qry.getResultStream().forEach(messageLog -> {
            MessageLogDto messageLogDto = new MessageLogDto().setTimestamp(new Date(messageLog.getTimestamp())).setEvent(MessageLogEvent.ofEventId(messageLog.getLogMessageID())).setAdditionalText(this.getPlainText(messageLog.getAdditionalText())).setReferencedMessageId(this.getReferencedMessageId(messageLog.getAdditionalText()));
            result.add(messageLogDto);
        });
        return result;
    }

    private Long getReferencedMessageId(String additionalText) {
        String url;
        MultiValueMap parameters;
        List param;
        if (additionalText == null) {
            return null;
        }
        Matcher matcher = PATTERN.matcher(additionalText);
        if (matcher.find() && (param = (List)(parameters = UriComponentsBuilder.fromUriString((String)(url = matcher.group(1))).build().getQueryParams()).get((Object)"messagedataid")) != null && !param.isEmpty()) {
            return Long.parseLong((String)param.getFirst());
        }
        return null;
    }

    private String getPlainText(String originalText) {
        if (originalText == null) {
            return null;
        }
        Matcher matcher = PATTERN.matcher(originalText);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return originalText;
    }
}

