/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.message;

import de.ponton.xmlpipe.rest.exception.ExceptionDto;
import de.ponton.xmlpipe.rest.exception.ExceptionDtoFactory;
import de.ponton.xmlpipe.rest.exception.ResourceNotFoundException;
import de.ponton.xmlpipe.rest.message.MessageArtifact;
import de.ponton.xmlpipe.rest.message.MessageDetailDto;
import de.ponton.xmlpipe.rest.message.MessageDetailService;
import de.ponton.xmlpipe.rest.message.MessageLogInfoService;
import de.ponton.xmlpipe.rest.message.MessageService;
import de.pontonconsulting.xmlpipe.messagemonitor.MessageDeleteService;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/messages"})
@Validated
public class MessageController {
    public static final String DOCUMENTATION_TAG_MESSAGE = "Message";
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + MessageController.class.getName()));
    private final MessageService messageService;
    private final MessageDetailService messageDetailService;
    private final MessageLogInfoService messageLogInfoService;
    private final MessageDeleteService messageDeleteService;
    private final ExceptionDtoFactory exceptionDtoFactory;

    public MessageController(MessageService messageService, MessageDeleteService messageDeleteService, MessageLogInfoService messageLogInfoService, ExceptionDtoFactory exceptionDtoFactory, MessageDetailService messageDetailService) {
        this.messageService = messageService;
        this.messageDeleteService = messageDeleteService;
        this.messageLogInfoService = messageLogInfoService;
        this.exceptionDtoFactory = exceptionDtoFactory;
        this.messageDetailService = messageDetailService;
    }

    @GetMapping(value={"/{messageId}/detail"})
    @Operation(summary="Get message details", description="permission:MESSAGES_DETAIL_GET<br><br>Get message details of the message for the given technical id", tags={"Message"})
    @Secured(value={"MESSAGES_DETAIL_GET"})
    public ResponseEntity<MessageDetailDto> getMessageDetail(@PathVariable long messageId) {
        MessageDetailDto result = this.messageDetailService.buildMessageDetailDto(messageId);
        return ResponseEntity.ok((Object)result);
    }

    @PutMapping(value={"{messageId}/logInfo"})
    @Operation(summary="Update message log info", description="permission:MESSAGES_LOG_INFO_PUT<br><br>Updates message log info of the message for the given technical id", tags={"Message"})
    @Secured(value={"MESSAGES_LOG_INFO_PUT"})
    public ResponseEntity<Void> updateMessageLogInfo(@PathVariable long messageId, @Valid @RequestBody @Size(max=128, message="too long") @Valid @Size(max=128, message="too long") String logInfo) {
        this.messageLogInfoService.updateLogInfo(messageId, logInfo);
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="Get a Message Raw Content", description="permission:MESSAGES_RAW_GET<br><br>Returns a Message as Raw content", tags={"Message"})
    @GetMapping(value={"/{messageId}/raw"})
    @Secured(value={"MESSAGES_RAW_GET"})
    public void viewRawMessage(HttpServletRequest request, HttpServletResponse httpServletResponse, @PathVariable long messageId) throws IOException, DbException {
        this.messageService.viewMessage(httpServletResponse, MessageArtifact.RAW_PAYLOAD, request.getRemoteUser(), messageId);
        httpServletResponse.setStatus(200);
    }

    @Operation(summary="Get a Message Transport Envelope", description="permission:MESSAGES_ENVELOPE_GET<br><br>Returns a Message Transport Envelope", tags={"Message"})
    @GetMapping(value={"/{messageId}/envelope"})
    @Secured(value={"MESSAGES_ENVELOPE_GET"})
    public void viewMessageEnvelope(HttpServletRequest request, HttpServletResponse httpServletResponse, @PathVariable long messageId) throws IOException, DbException {
        this.messageService.viewMessage(httpServletResponse, MessageArtifact.PACKAGING_ENVELOPE, request.getRemoteUser(), messageId);
        httpServletResponse.setStatus(200);
    }

    @Operation(summary="Get a Message XML", description="permission:MESSAGES_HTML_GET<br><br>Returns a Message as XML", tags={"Message"})
    @GetMapping(value={"/{messageId}/html"})
    @Secured(value={"MESSAGES_HTML_GET"})
    public void viewMessageHTML(HttpServletRequest request, HttpServletResponse httpServletResponse, @PathVariable long messageId) throws IOException, DbException {
        this.messageService.viewMessage(httpServletResponse, MessageArtifact.HTML_RENDERED_PAYLOAD, request.getRemoteUser(), messageId);
        httpServletResponse.setStatus(200);
    }

    @Operation(summary="Get a Message Backend XML", description="permission:MESSAGES_BACKEND_XML_GET<br><br>Returns a Message as Backend XML", tags={"Message"})
    @GetMapping(value={"/{messageId}/backendxml"})
    @Secured(value={"MESSAGES_BACKEND_XML_GET"})
    public void viewMessageBackendXML(HttpServletRequest request, HttpServletResponse httpServletResponse, @PathVariable long messageId) throws IOException, DbException {
        this.messageService.viewMessage(httpServletResponse, MessageArtifact.BACKEND_ENVELOPE, request.getRemoteUser(), messageId);
        httpServletResponse.setStatus(200);
    }

    @DeleteMapping(value={"/{databaseId}"})
    @Secured(value={"MESSAGES_DELETE"})
    @Operation(summary="Delete a message", description="permission:MESSAGES_DELETE<br><br>Deletes a message. In addition, all messages assigned to this message are deleted.", tags={"Message"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public synchronized ResponseEntity<Void> deleteMessage(@PathVariable Long databaseId, @AuthenticationPrincipal UserDetails user) throws IOException, DbException, ResourceNotFoundException {
        this.messageDeleteService.deleteMessage(databaseId, user.getUsername());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ResponseEntity<ExceptionDto> handleNotFound(Exception e) {
        LOG.error("Message not found, {}", (Object)e.getMessage());
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={DbException.class, IOException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<ExceptionDto> handleException(Exception e) {
        if (LOG.isDebugEnabled()) {
            LOG.error(e.getClass().getSimpleName() + " occurred: " + e.getMessage(), (Throwable)e);
        } else {
            LOG.error(e.getClass().getSimpleName() + " occurred: " + e.getMessage());
        }
        return new ResponseEntity((Object)this.exceptionDtoFactory.create(e), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }
}

