/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.listener.proxy;

import de.ponton.xmlpipe.rest.listener.common.ListenerIpConnectionDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the configuration of the listener proxy.")
public class ListenerProxyDto {
    @NotNull
    @Valid
    @Schema(description="The connection configuration of the listener proxy.")
    private ListenerIpConnectionDto connection;
    @Schema(description="Set to 'true' to enable the proxy, set to 'false' to disable it.")
    private boolean enabled;

    public ListenerIpConnectionDto getConnection() {
        return this.connection;
    }

    public ListenerProxyDto setConnection(ListenerIpConnectionDto connection) {
        this.connection = connection;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ListenerProxyDto setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListenerProxyDto)) {
            return false;
        }
        ListenerProxyDto that = (ListenerProxyDto)o;
        return this.enabled == that.enabled && Objects.equals(this.connection, that.connection);
    }

    public int hashCode() {
        return Objects.hash(this.connection, this.enabled);
    }

    public String toString() {
        return "ListenerProxyDto{connection=" + String.valueOf(this.connection) + ", enabled=" + this.enabled + "}";
    }
}

