/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.listener.http;

import de.ponton.xmlpipe.rest.listener.http.HttpListenerDto;
import de.ponton.xmlpipe.rest.listener.http.HttpsListenerDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the configuration of the HTTP and HTTPS listeners.")
public class WebListenerDto {
    @Valid
    @Schema(description="The configuration of the HTTP listener.")
    private HttpListenerDto httpListener;
    @Valid
    @Schema(description="The configuration of the HTTPS listener.")
    private HttpsListenerDto httpsListener;
    @NotNull
    @Min(value=1L)
    @Max(value=0x40000000L)
    @Schema(description="Maximal data size of a message in Byte which is forwarded to the messenger. If the size of a message exceeds this value, the message will be rejected.")
    private @NotNull @Min(value=1L) @Max(value=0x40000000L) Long maxDataSize;

    public HttpListenerDto getHttpListener() {
        return this.httpListener;
    }

    public WebListenerDto setHttpListener(HttpListenerDto httpListener) {
        this.httpListener = httpListener;
        return this;
    }

    public HttpsListenerDto getHttpsListener() {
        return this.httpsListener;
    }

    public WebListenerDto setHttpsListener(HttpsListenerDto httpsListener) {
        this.httpsListener = httpsListener;
        return this;
    }

    public Long getMaxDataSize() {
        return this.maxDataSize;
    }

    public WebListenerDto setMaxDataSize(Long maxDataSize) {
        this.maxDataSize = maxDataSize;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebListenerDto)) {
            return false;
        }
        WebListenerDto that = (WebListenerDto)o;
        return Objects.equals(this.httpListener, that.httpListener) && Objects.equals(this.httpsListener, that.httpsListener) && Objects.equals(this.maxDataSize, that.maxDataSize);
    }

    public int hashCode() {
        return Objects.hash(this.httpListener, this.httpsListener, this.maxDataSize);
    }

    public String toString() {
        return "WebListenerDto{httpListener=" + String.valueOf(this.httpListener) + ", httpsListener=" + String.valueOf(this.httpsListener) + ", maxDataSize=" + this.maxDataSize + "}";
    }
}

