/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.listener.http;

import de.ponton.xmlpipe.rest.listener.common.ListenerIpConnectionDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the configuration of the HTTPS listener.")
public class HttpsListenerDto {
    @NotNull
    @Valid
    @Schema(description="The listener IP address and the port number is used to receive messages from communication partners.")
    private ListenerIpConnectionDto connection;
    @Schema(description="Set to 'true' to enable the HTTPS listener, set to 'false' to disable it.")
    private boolean enabled;
    @Schema(description="Set to 'true' to enable SNI Host Verification for HTTPS requests, set to 'false' otherwise. If this option is enabled you need to install a valid certificate to your system.")
    private boolean sniEnabled;
    @Schema(description="Set to 'true' to enable SSL client authentication for HTTPS requests, set to 'false' otherwise. If this option is enabled you need to install a certificate for each communication partner which sends messages via HTTPS to your system.")
    private boolean doClientCertificateCheck;
    @Schema(description="Set to 'true' to enable SSL client authentication for HTTPS requests, set to 'false' otherwise. If this option is enabled you need to install a CA certificate for each communication partner which sends messages via HTTPS to your system.")
    private boolean doClientCertificateAuth;
    @Schema(description="Set to 'true' to automatically use the certificates from the configured partners for SSL client authorization, set to false to use different certificates.")
    private boolean usePartnerCertificate;

    public boolean isSniEnabled() {
        return this.sniEnabled;
    }

    public HttpsListenerDto setSniEnabled(boolean sniEnabled) {
        this.sniEnabled = sniEnabled;
        return this;
    }

    public ListenerIpConnectionDto getConnection() {
        return this.connection;
    }

    public HttpsListenerDto setConnection(ListenerIpConnectionDto connection) {
        this.connection = connection;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public HttpsListenerDto setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isDoClientCertificateCheck() {
        return this.doClientCertificateCheck;
    }

    public HttpsListenerDto setDoClientCertificateCheck(boolean doClientCertificateCheck) {
        this.doClientCertificateCheck = doClientCertificateCheck;
        return this;
    }

    public boolean isUsePartnerCertificate() {
        return this.usePartnerCertificate;
    }

    public HttpsListenerDto setUsePartnerCertificate(boolean usePartnerCertificate) {
        this.usePartnerCertificate = usePartnerCertificate;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpsListenerDto)) {
            return false;
        }
        HttpsListenerDto that = (HttpsListenerDto)o;
        return this.enabled == that.enabled && this.doClientCertificateCheck == that.doClientCertificateCheck && this.doClientCertificateAuth == that.doClientCertificateAuth && this.usePartnerCertificate == that.usePartnerCertificate && Objects.equals(this.connection, that.connection);
    }

    public int hashCode() {
        return Objects.hash(this.connection, this.enabled, this.doClientCertificateCheck, this.usePartnerCertificate, this.doClientCertificateAuth);
    }

    public String toString() {
        return "HttpsListenerDto{connection=" + String.valueOf(this.connection) + ", enabled=" + this.enabled + ", doClientCertificateCheck=" + this.doClientCertificateCheck + ", usePartnerCertificate=" + this.usePartnerCertificate + ", doClientCertificateAuthentication=" + this.doClientCertificateAuth + "}";
    }

    public boolean isDoClientCertificateAuth() {
        return this.doClientCertificateAuth;
    }

    public HttpsListenerDto setDoClientCertificateAuth(boolean doClientCertificateAuth) {
        this.doClientCertificateAuth = doClientCertificateAuth;
        return this;
    }
}

