/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.listener.ftp;

import de.ponton.xmlpipe.rest.cpp.validation.PartnerExistenceConstraint;
import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.settings.common.authentication.AuthenticationDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="FTP logins allows your partners to connect to your FTP Listener. Every login is linked to one partner profile.")
public class FtpLoginDto {
    @NotNull
    @Valid
    @Schema(description="The authentication information for the access to the FTP listener.)")
    private AuthenticationDto authentication;
    @NotBlank
    @PartnerExistenceConstraint
    @Schema(description="The id of the partner linked to this FTP login.")
    @TrimmedField
    private String partnerId;

    public AuthenticationDto getAuthentication() {
        return this.authentication;
    }

    public FtpLoginDto setAuthentication(AuthenticationDto authentication) {
        this.authentication = authentication;
        return this;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public FtpLoginDto setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FtpLoginDto)) {
            return false;
        }
        FtpLoginDto that = (FtpLoginDto)o;
        return Objects.equals(this.authentication, that.authentication) && Objects.equals(this.partnerId, that.partnerId);
    }

    public int hashCode() {
        return Objects.hash(this.authentication, this.partnerId);
    }

    public String toString() {
        return "FtpLoginDto{authentication=" + String.valueOf(this.authentication) + ", partnerId='" + this.partnerId + "'}";
    }
}

