/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.listener.ftp;

import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.listener.ftp.FtpDataConnectionDtoConstraint;
import de.ponton.xmlpipe.rest.listener.ftp.FtpLoginDto;
import de.ponton.xmlpipe.rest.validation.IpAddressConstraint;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@FtpDataConnectionDtoConstraint
@Schema(description="The data connection IP address and the port number is used to receive messages from communication partners.<br> NOTE: When the FTP Listener has used up all data ports (one per partner doing data transfer), the next partner will have to wait for an available port.")
public class FtpDataConnectionDto {
    @NotBlank
    @Size(max=1024)
    @IpAddressConstraint
    @Schema(description="The IP address of the data connection to the FTP server.")
    @TrimmedField
    private @NotBlank @Size(max=1024) String ip;
    @NotNull
    @Min(value=1L)
    @Max(value=65535L)
    @Schema(description="The lower limit of the port range for the data connections.")
    private @NotNull @Min(value=1L) @Max(value=65535L) Integer fromPort;
    @NotNull
    @Min(value=1L)
    @Max(value=65535L)
    @Schema(description="The upper limit of the port range for the data connections. Omit value (but don't set to null) for no upper port limit.")
    private @NotNull @Min(value=1L) @Max(value=65535L) Integer toPort = 65535;
    @NotNull
    @Valid
    @Size(max=1000)
    @Schema(description="A list of logins for the FTP server.")
    private @NotNull @Valid @Size(max=1000) List<@NotNull @Valid FtpLoginDto> logins;

    public String getIp() {
        return this.ip;
    }

    public FtpDataConnectionDto setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public Integer getFromPort() {
        return this.fromPort;
    }

    public FtpDataConnectionDto setFromPort(Integer fromPort) {
        this.fromPort = fromPort;
        return this;
    }

    public Integer getToPort() {
        return this.toPort;
    }

    public FtpDataConnectionDto setToPort(Integer toPort) {
        this.toPort = toPort;
        return this;
    }

    public List<FtpLoginDto> getLogins() {
        return this.logins;
    }

    public FtpDataConnectionDto setLogins(List<FtpLoginDto> logins) {
        this.logins = logins;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FtpDataConnectionDto)) {
            return false;
        }
        FtpDataConnectionDto that = (FtpDataConnectionDto)o;
        return Objects.equals(this.ip, that.ip) && Objects.equals(this.fromPort, that.fromPort) && Objects.equals(this.toPort, that.toPort) && Objects.equals(this.logins, that.logins);
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.fromPort, this.toPort, this.logins);
    }

    public String toString() {
        return "FtpDataConnectionDto{ip='" + this.ip + "', fromPort=" + this.fromPort + ", toPort=" + this.toPort + ", logins=" + String.valueOf(this.logins) + "}";
    }
}

