/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.xmlpipe.rest.listener.common;

import de.ponton.xmlpipe.rest.jackson.TrimmedField;
import de.ponton.xmlpipe.rest.validation.IpAddressOrAsteriskConstraint;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.springframework.validation.annotation.Validated;

@Validated
@Schema(description="Holds the configuration of a connection to a listener.")
public class ListenerIpConnectionDto {
    @NotBlank
    @Size(max=1024)
    @IpAddressOrAsteriskConstraint
    @Schema(description="The IP address of the listener to connect. The asterisk (*) as value for the ip accepts incoming connections on all available IP addresses on the specified port number.")
    @TrimmedField
    private @NotBlank @Size(max=1024) String ip;
    @NotNull
    @Min(value=1L)
    @Max(value=65535L)
    @Schema(description="The port of the listener to connect.")
    private @NotNull @Min(value=1L) @Max(value=65535L) Integer port;

    public String getIp() {
        return this.ip;
    }

    public ListenerIpConnectionDto setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public ListenerIpConnectionDto setPort(Integer port) {
        this.port = port;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListenerIpConnectionDto)) {
            return false;
        }
        ListenerIpConnectionDto that = (ListenerIpConnectionDto)o;
        return Objects.equals(this.ip, that.ip) && Objects.equals(this.port, that.port);
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.port);
    }

    public String toString() {
        return "ListenerIpConnectionDto{ip='" + this.ip + "', port=" + this.port + "}";
    }
}

